package com.elitesland.support.provider.item.param;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
//import java.util.Map;

/**
 1.入参：经营公司编码（必填）、门店创建时间、最近更新时间、商品编码（选填）

 2.个时间二选一的必填；
 查询时间段限制暂定1个月；
 做成分页查询；
 */
@Data
public class ItmItemBusinessParam extends AbstractOrderQueryParam implements Serializable {
    private static final long serialVersionUID = 3344534498352255891L;


    @ApiModelProperty("经营公司编码，批量查询")
    private List<String> buCodeList;

    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTimeStart;
    private LocalDateTime createTimeEnd;

    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTimeStart;
    private LocalDateTime modifyTimeEnd;

    @ApiModelProperty("商品编码，批量查询")
    private List<String> itemCodeList;


}
