package com.elitesland.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;


/**
 * @author Chris
 * @date 2021-04-12
 */
@Data
public class ItmItemQualifyRpcDTO implements Serializable {

    private static final long serialVersionUID = -7951643466587041382L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("记录唯一ID")
    private Long id;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("spuId")
    private Long spuId;

    /**
     * 资质编号
     */
    @ApiModelProperty(value = "资质编号")
    private String qualifyNo;

    /**
     * 资质名称
     */
    @ApiModelProperty(value = "资质名称")
    private String qualifyName;

    /**
     * 资质简称
     */
    @ApiModelProperty(value = "资质简称")
    private String qualifyAbbreviation;

    @SysCode(sys = "yst-supp", mod = "QUALIFY_TYPE")
    @ApiModelProperty("资质类型 [UDC]ITM:QUALIFY_TYPE")
    private String qualifyType;
    private String qualifyTypeName;

    @SysCode(sys = "yst-supp", mod = "STATUS_ACTIVEORNO")
    @ApiModelProperty("资质证照状态 [UDC]COM:STATUS_ACTIVEORNO")
    private String qualifyStatus;
    private String qualifyStatusName;

    /**
     * 生效日期
     */
    @ApiModelProperty(value = "生效日期")
    private LocalDateTime validFrom;

    /**
     * 失效日期
     */
    @ApiModelProperty(value = "失效日期")
    private LocalDateTime validTo;

    /**
     * 资质文件编号
     */
    @ApiModelProperty(value = "资质文件编号")
    private String qualifyFileCode;

    /**
     * 资质文件名称
     */
    @ApiModelProperty(value = "资质文件名称")
    private String qualifyFileName;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "是否展示小程序")
    private Boolean isShow;



    /**
     * 资质简称
     */
    @ApiModelProperty(value = "要求概述")
    private String qualifyDesc;
}
