package com.elitesland.support.provider.org.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author Tom.su
 * @program yst-support-domain
 * @description 公司行政区划保存/更新传输类
 * @date 2021/09/09 11:19
 */
@Data
@ApiModel(description = "门店费用明细")
public class OrgStoreCostRpcSaveParam implements Serializable {

    @ApiModelProperty(value = "Id")
    private Long id;

    @ApiModelProperty(value = "日期")
    private LocalDateTime costDate;

    @ApiModelProperty(value = "营业额")
    private BigDecimal cost;

    @ApiModelProperty(value = "水电费")
    private BigDecimal money;

    @ApiModelProperty(value = "租金")
    private BigDecimal rent;

    @ApiModelProperty(value = "门店ID")
    private Long masId;

    @ApiModelProperty("项目")
    private String type;

}