package com.elitesland.support.provider.pri.service.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@Builder(builderMethodName = "childBuilder")
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("商品价格查询条件")
public class ItmPriPriceRpcDtoParam implements Serializable {

    private static final long serialVersionUID = -4338427891182297120L;

    /**
     * 取价参数唯一标识，允许为空，同一次调用该UUID不允许重复
     * 设置UUID后，查询结果会将该UUID返回，可根据入参的UUID去结果集中匹配对应的查询结果
     */
    @ApiModelProperty("取价参数唯一标识，允许为空，同一次调用该UUID不允许重复")
    private String uuid;

    @ApiModelProperty("商品ID列表")
    private Long itemId;

    @ApiModelProperty("商品编号")
    private String itemCode;

    @ApiModelProperty(value = "销售组织")
    private String saleOrg;

    @ApiModelProperty(value = "价格类别 [UDC]yst-support: PRICE_CLS")
    private String priceCls;

    @ApiModelProperty(value = "价格类型 [UDC]yst-support: PRICE_TYPE")
    private String priceType;

    @ApiModelProperty(value = "分销渠道")
    private String saleChannel;

    @ApiModelProperty(value = "客户区域 [UDC]yst-support: REGION")
    private String region;

    @ApiModelProperty("生效时间点，用于查询指定生效时间点的数据，不传时取当前生效的时间")
    private LocalDateTime validTime;

    @ApiModelProperty(value = "价格状态")
    private String priceStatus;

    @ApiModelProperty(value = "基本计量单位")
    private String uom;

    @ApiModelProperty(value = "货币码")
    private String currCode;

    @ApiModelProperty("公司编号")
    private String ouCode;

    @ApiModelProperty("客户编码")
    private String custCode;
}
