package com.elitesland.support.provider.org.param;

import com.elitescloud.boot.core.support.customfield.common.AbstractCustomFieldQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author Chris
 * @date 2021-06-03
 */
@Data
@ApiModel("地址薄-银行信息DTO查询参数")
public class OrgBankAccRpcDtoParam extends AbstractCustomFieldQueryParam implements Serializable {

    private static final long serialVersionUID = 412272611076313301L;

    /**
     * 地址号列表
     */
    @ApiModelProperty("地址号列表")
    private List<Long> addrNos;

    /**
     * 账号类型:[UDC]ORG:ADDR_BANKACC_TYPE
     */
    @ApiModelProperty("账号类型:[UDC]ORG:ADDR_BANKACC_TYPE")
    private String accType;

    /**
     * 是否默认：1是，0否
     */
    @ApiModelProperty("是否默认：1是，0否")
    private Boolean defaultFlag;

    /**
     * 银行名称，支持模糊查询
     */
    @ApiModelProperty("银行名称，支持模糊查询")
    private String bankName;

    /**
     * 网点名称， 支持模糊查询
     */
    @ApiModelProperty("网点名称， 支持模糊查询")
    private String branchName;

    /**
     * 开户行账号，支持模糊查询
     */
    @ApiModelProperty("开户行账号，支持模糊查询")
    private String bankAcc;

    /**
     * 收付款方式
     */
    @ApiModelProperty("收付款方式")
    private String payCollectMethod;


    /**
     * 开户行账号名称，支持模糊查询
     */
    @ApiModelProperty(value = "开户行账号名称")
    private String bankAccountName;

    /**
     * 开户行账号组合，支持模糊查询
     */
    @ApiModelProperty(value = "开户行账号组合")
    private String bankAccountComp;

    /**
     * 数据来源
     */
    @ApiModelProperty("数据来源")
    private List<String> dataSources;
}
