package com.elitesland.support.provider.dingding.dto;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.Date;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2025/10/20 9:34
 */
@Data
public class TodoCreateRequestDTO {

    /**
     * 待办标题
     */
    @NotBlank(message = "标题不能为空")
    private String subject;

    /**
     * 待办描述
     */
    private String description;

    /**
     * 截止时间
     */
    private Date dueTime;

    /**
     * 执行者用户ID列表
     */
    private List<String> executorIds;

    /**
     * 详情页URL
     */
    private TodoDtlRequestDTO detailUrl;

    /**
     * 业务标识
     */
    private String bizTag;

    /**
     * 来源标识
     */
    private String sourceId;

    //钉钉用户 unionId
    private String unionId;


    private String taskId;

    private Long docId;

    private List<String> ystUserIds;

    //工作流ID
    private String procInstId;

    private Boolean isDown;


    //需要更新状态的id
    private List<Long> ids;

    //来源类型
    private String sourceType;
}
