package com.elitesland.support.provider.item.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/3/25
 */
@Data
@ApiModel(description = "商品主表提供给供应链分页查询条件")
public class ItmItemSupplyPagingParam implements Serializable {

    /**
     * 页码,默认为1
     */
    @ApiModelProperty(value = "页码,默认为1", example = "0")
    private Integer current = 0;

    /**
     * 页大小,默认为10
     */
    @ApiModelProperty(value = "页大小,默认为10", example = "10")
    private Integer size = 10;

    /**
     * 品项编号
     */
    @ApiModelProperty("品项编号")
    private String itemCode;

    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    private String itemName;
}
