package com.elitesland.support.provider.item.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author Chris
 * @date 2021-04-27
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("菜品DTO查询参数")
public class ThaliItemRpcDtoParam implements Serializable {

    @ApiModelProperty("菜品ID列表")
    private List<Long> itemIds;

    @ApiModelProperty("菜品编码列表")
    private List<String> itemCodes;

    @ApiModelProperty("半成品子件编码")
    private List<String> spuItemCode;

    @ApiModelProperty(value = "规格值编码列表")
    private List<String> sizeCodes;

}
