package com.elitesland.support.provider.org.param;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class OrgAddrAddressRpcUpdateParam extends CustomFieldBaseModelVo implements Serializable {
    private static final long serialVersionUID = -3882376179816449654L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("记录唯一ID")
    private Long id;

    /**
     * 地址号列表
     */
    @ApiModelProperty("地址号")
    private Long addrNo;

    /**
     * 地址类型(指送货地址，开票地址等):[UDC]ORG:ADDRESS_TYPE
     */
    @ApiModelProperty("地址类型(指送货地址，开票地址等):[UDC]ORG:ADDRESS_TYPE")
    private String addressType;

    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long buId;

    /**
     * BU名称
     */
    @ApiModelProperty(value = "BU名称")
    private String buName;

    /**
     * 联系人姓名，支持模糊查询
     */
    @ApiModelProperty("联系人姓名，支持模糊查询")
    private String contPerson;

    /**
     * createor
     */
    @ApiModelProperty(value = "createor")
    private String createor;

    /**
     * 是否默认：true是，false否
     */
    @ApiModelProperty("是否默认：true是，false否")
    private Boolean defaultFlag;

    /**
     * 电邮
     */
    @ApiModelProperty("电邮")
    private String email;

    /**
     * 手机号码，支持模糊查询
     */
    @ApiModelProperty("手机号码，支持模糊查询")
    private String mobile;

    /**
     * 部门名称
     */
    @ApiModelProperty(value = "部门名称")
    private String ouName;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /***
     * 产品大类(中文拼接)
     */
    @ApiModelProperty(value = "产品大类(中文拼接)")
    private String es1;

    /***
     * 产品大类(udc拼接)
     */
    @ApiModelProperty(value = "产品大类(udc拼接)")
    private String es1Udc;

    /***
     * 意向区域(中文拼接)
     */
    @ApiModelProperty(value = "意向区域(中文拼接)")
    private String es2;

    /***
     * 意向区域(udc拼接)
     */
    @ApiModelProperty(value = "意向区域(udc拼接)")
    private String es2Udc;

    /***
     * 身份证号
     */
    @ApiModelProperty(value = "身份证号")
    private String es4;

    /***
     * 代理权权限
     */
    @ApiModelProperty(value = "代理权权限")
    private String es6;

    /***
     * 代理权权限(中文名称)
     */
    @ApiModelProperty(value = "代理权权限(中文名称)")
    private String es6Name;

    /***
     * es7
     */
    @ApiModelProperty(value = "es7")
    private String es7;

    /**
     * 数据来源
     */
    @ApiModelProperty("数据来源")
    private String dataSource;

    @ApiModelProperty(value = "正式表ID")
    private Long oldId;

}
