package com.elitesland.support.provider.item.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author : Scott.zhang(zhang hang)
 * @Date : 2021/9/2817:44
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("品类编码查询参数")
public class ItmItemCateSyncParam implements Serializable {
    private static final long serialVersionUID = -8158335005697180277L;

    @ApiModelProperty("品类编码")
    private String itemCateCode;

    @ApiModelProperty("同步状态")
    private String syncStatus;

    @ApiModelProperty("同步错误")
    private String syncError;

    @ApiModelProperty("外部系统ID")
    private String outSysKey;

    @ApiModelProperty("业务KEY")
    private String businessKey;


}
