package com.elitesland.support.provider.item.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;


/**
 * @author Chris
 * @date 2021-03-03
 */
@Data
@ApiModel(description = "商品类目")
public class ItmItemPropRpcDTO implements Serializable {

    private static final long serialVersionUID = -3383058449775823322L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("记录唯一ID")
    private Long id;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("商品ID")
    private Long itemId;

    /**
     * 属性类型
     */
    @ApiModelProperty(value = "属性类型")
    private String catePropType;

    /**
     * 属性编码
     */
    @ApiModelProperty(value = "属性编码")
    private String catePropCode;

    /**
     * 属性名称
     */
    @ApiModelProperty(value = "属性名称")
    private String catePropName;

    /**
     * 属性值
     */
    @ApiModelProperty(value = "属性值")
    private String propValue;

}
