package com.elitesland.support.provider.pri.cache.client;

import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class PriPriceCache implements Serializable {

    private static final long serialVersionUID = 461917513443540236L;

    @ApiModelProperty(value = "公司ID")
    private Long ouId;

    @ApiModelProperty(value = "公司编码")
    private String ouCode;

    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "客户编码")
    private String custCode;

    @ApiModelProperty(value = "销售组织 yst-support: PRI_SALE_ORG")
    private String saleOrg;

    @ApiModelProperty(value = "分销渠道")
    private String saleChannel;

    @ApiModelProperty(value = "区域")
    private String region;

    @ApiModelProperty(value = "基本计量单位")
    private String uom;

    @ApiModelProperty(value = "货币码")
    private String currCode;

    @ApiModelProperty(value = "货币码")
    private String currName;

    @ApiModelProperty(value = "基本计量单位")
    private String uomName;

    @ApiModelProperty(value = "区域")
    private String regionName;

    @ApiModelProperty(value = "分销渠道")
    private String saleChannelName;

    @ApiModelProperty(value = "价格类别")
    @Comment("价格类别")
    private String priceCls;

    @ApiModelProperty(value = "价格类别")
    @Comment("价格类别")
    private String priceClsName;

    @ApiModelProperty(value = "价格类型")
    private String priceType;

    @ApiModelProperty(value = "价格类型")
    private String priceTypeName;

    @ApiModelProperty(value = "价格")
    private BigDecimal price;

    @ApiModelProperty(value = "未税 价格")
    private BigDecimal netPrice;

    @ApiModelProperty(value = "销售组织名称")
    private String saleOrgName;

    @ApiModelProperty(value = "商品编码")
    private Long itemId;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "商品类型")
    private String itemType2;

    @ApiModelProperty(value = "商品类型")
    private String itemType2Name;

    @ApiModelProperty(value = "税率编号")
    private String taxRateNo;

    @ApiModelProperty(value = "税率")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "定价元素路径")
    private String elementPath;

    @ApiModelProperty(value = "定价元素路径值")
    private String elementPathValue;

    @ApiModelProperty(value = "市场价")
    private BigDecimal price1;

    @ApiModelProperty(value = "B端毛利控制率")
    private BigDecimal price2;

    @ApiModelProperty(value = "C端毛利控制率")
    private BigDecimal price3;

    public String getCacheKey(Long tenantId, String dateStr) {
        return tenantId + ":" + priceType + ":" + dateStr + ":" + elementPath + ":" + elementPathValue;
    }

    public static String getCacheKey(Long tenantId, String dateStr, String priceType, String elementPath, String elementPathValue) {
        return tenantId + ":" + priceType + ":" + dateStr + ":" + elementPath + ":" + elementPathValue;
    }
}
