/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.support.provider.pri.cache.client;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.tenant.client.common.TenantClient;
import com.elitesland.support.provider.pri.cache.client.PriPriceCache;
import com.elitesland.support.provider.pri.cache.client.PriPriceConfCache;
import com.elitesland.support.provider.pri.cache.client.PriPricePriorityConfCache;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class PriPriceCacheClient {
    private static final String PRI_CACHE_STATUS_KEY = "pri_price_cache_status:";
    private static RedisUtils redisUtils = (RedisUtils)SpringUtil.getBean(RedisUtils.class);

    public static void cacheConf(List<PriPriceConfCache> cacheList) {
        redisUtils.set("pri_price_conf_cache:" + TenantClient.getSessionTenant().getId(), cacheList);
    }

    public static List<PriPriceConfCache> findConfCache() {
        String cacheKey = "pri_price_conf_cache:" + TenantClient.getSessionTenant().getId();
        Object cache = redisUtils.get(cacheKey);
        if (cache == null) {
            return new ArrayList<PriPriceConfCache>();
        }
        return (List)cache;
    }

    public static void cachePriorityConf(List<PriPricePriorityConfCache> cacheList) {
        redisUtils.set("pri_priority_conf_cache:" + TenantClient.getSessionTenant().getId(), cacheList);
    }

    public static List<PriPricePriorityConfCache> findPriorityConfCache() {
        String cacheKey = "pri_priority_conf_cache:" + TenantClient.getSessionTenant().getId();
        Object cache = redisUtils.get(cacheKey);
        if (cache == null) {
            return new ArrayList<PriPricePriorityConfCache>();
        }
        return (List)cache;
    }

    public static void clearCacheStatus() {
        if (TenantClient.getSessionTenant() == null) {
            return;
        }
        String cacheKey = PRI_CACHE_STATUS_KEY + TenantClient.getSessionTenant().getId();
        redisUtils.del(new String[]{cacheKey});
    }

    public static Boolean cacheFinished() {
        String cacheKey = PRI_CACHE_STATUS_KEY + TenantClient.getSessionTenant().getId();
        Object o = redisUtils.get(cacheKey);
        if (o == null) {
            return false;
        }
        if ((Integer)o == 1) {
            return true;
        }
        return false;
    }

    public static void cacheFinish() {
        if (TenantClient.getSessionTenant() == null) {
            return;
        }
        String cacheKey = PRI_CACHE_STATUS_KEY + TenantClient.getSessionTenant().getId();
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime end = now.withHour(23).withMinute(30);
        long validMills = LocalDateTimeUtil.between((LocalDateTime)now, (LocalDateTime)end).toMillis();
        redisUtils.set(cacheKey, (Object)1, validMills, TimeUnit.MILLISECONDS);
    }

    public static void cachePrice(List<PriPriceCache> priPriceCaches) {
        if (CollectionUtil.isEmpty(priPriceCaches)) {
            return;
        }
        Long tenantId = TenantClient.getSessionTenant().getId();
        String dateStr = LocalDateTimeUtil.format((LocalDate)LocalDate.now(), (String)"yyyyMMdd");
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime end = LocalDateTimeUtil.endOfDay((LocalDateTime)now);
        long validMills = LocalDateTimeUtil.between((LocalDateTime)now, (LocalDateTime)end).toMillis();
        for (PriPriceCache priPriceCach : priPriceCaches) {
            String key = priPriceCach.getCacheKey(tenantId, dateStr);
            redisUtils.set(key, (Object)priPriceCach, validMills, TimeUnit.MILLISECONDS);
        }
    }

    public static void removePrice(List<PriPriceCache> priPriceCaches) {
        if (CollectionUtil.isEmpty(priPriceCaches)) {
            return;
        }
        Long tenantId = TenantClient.getSessionTenant().getId();
        String dateStr = LocalDateTimeUtil.format((LocalDate)LocalDate.now(), (String)"yyyyMMdd");
        ArrayList<String> keys = new ArrayList<String>();
        for (PriPriceCache priPriceCach : priPriceCaches) {
            String key = priPriceCach.getCacheKey(tenantId, dateStr);
            keys.add(key);
        }
        redisUtils.del(keys.toArray(new String[keys.size()]));
    }

    public static List<PriPriceCache> findPrice(List<String> keyList) {
        if (CollectionUtil.isEmpty(keyList)) {
            return new ArrayList<PriPriceCache>();
        }
        ArrayList<PriPriceCache> result = new ArrayList<PriPriceCache>();
        List list = redisUtils.multiGet(keyList);
        for (Object obj : list) {
            if (obj == null) continue;
            result.add((PriPriceCache)obj);
        }
        return result;
    }
}

