package com.elitesland.support.provider.pri.service.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel("子件商品价格查询参数")
public class ItmBomPriceRpcDtoParam implements Serializable {

    private static final long serialVersionUID = -2580488265349117050L;

    /**
     * 取价参数唯一标识，允许为空，同一次调用该UUID不允许重复
     * 设置UUID后，查询结果会将该UUID返回，可根据入参的UUID去结果集中匹配对应的查询结果
     */
    @ApiModelProperty("取价参数唯一标识，允许为空，同一次调用该UUID不允许重复")
    private String uuid;

    @ApiModelProperty("子件商品编码")
    private String itemCode;

    @ApiModelProperty("组合商品编号")
    private String combineItemCode;

    @ApiModelProperty(value = "基本计量单位")
    private String uom;
}
