package com.elitesland.support.provider.org.param;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
@ApiModel(value = "门店在线支付保存入参")
public class OrgStoreOnlinePayRpcParamVO implements Serializable {
    private static final long serialVersionUID = -3342841575717594695L;

    @ApiModelProperty("记录唯一ID")
    private Long id;

    @ApiModelProperty("主表ID")
    private Long masId;

    @ApiModelProperty(value = "支付人类型")
    private String payerType;

    @ApiModelProperty(value = "开户类型")
    private String accountType;

    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "默认")
    private Boolean defaultFlag;

    @ApiModelProperty(value = "附件")
    private List<String> fileCodes;

    @JsonIgnore
    private String fileCode;

    @ApiModelProperty(value = "身份证号")
    private String idCardNo;

}
