package com.elitesland.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Chris
 * @date 2021-06-08
 */
@Data
public class ItmItemCateRpcDTO implements Serializable {

    private static final long serialVersionUID = -3072167463473514051L;

    /**
     * 品类id
     */
    private Long id;

    /**
     * 品类编号
     */
    private String itemCateCode;

    /**
     * 品类名称
     */
    private String itemCateName;

    /**
     * 父类 id
     */
    private Long pid;

    /**
     * 品类层级
     */
    private Integer level;

    /**
     * 父级品类编号
     */
    private String parentCode;

    /**
     * 父级品类名称
     */
    private String parentName;


    @ApiModelProperty("同步状态(yst-fin/AP_SYNC_STATUS)")
    @SysCode(sys = "yst-fin", mod = "AP_SYNC_STATUS")
    private String syncStatus;
    private String syncStatusName;

    @ApiModelProperty("推送日志")
    private String syncError;

    @ApiModelProperty("外部系统ID")
    private String outSysKey;

}
