package com.elitesland.support.provider.org.param;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.support.provider.org.RpcBaseModel;
import com.elitesland.support.provider.org.dto.OrgStoreCostRpcSaveParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.validation.Valid;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/4/1
 */
@Data
@ApiModel("门店申请表新增参数")
public class OrgStoreApproveDtoParam extends RpcBaseModel implements Serializable {

    private static final long serialVersionUID = 4124125226195955187L;

    /**
     * 门店id
     */
    @ApiModelProperty(value = "门店id")
    private Long id;


    @ApiModelProperty(value = "盟食亿ID")
    private String msyStoreId;

    /**
     *申请单号
     */
    @ApiModelProperty(value = "申请单号")
    private String applyNo;

    /**
     *申请单类型
     */
    @ApiModelProperty(value = "申请单类型 yst-support: APPLY_TYPE")
    private String applyStatus;

    /**
     * 申请类型
     */
    @ApiModelProperty(value = "申请类型")
    private String applyType;

    /**
     * 门店编号
     */
    @ApiModelProperty(value = "门店ID")
    private String storeCode;

    /**
     * 门店编号
     */
    @ApiModelProperty(value = "门店编号")
    private String storeCode2;

    /**
     * 门店名称
     */
    @ApiModelProperty(value = "门店名称")
    private String storeName;

    /**
     * 门店类型
     */
    @ApiModelProperty(value = "门店类型")
    private String storeType;

    /**
     * 门店类型2
     */
    @ApiModelProperty(value = "门店类型2")
    private String storeType2;



    /**
     * 门店类型3
     */
    @ApiModelProperty(value = "门店类型3")
    private String storeType3;

    /**
     * 所属上级组织
     */
    @ApiModelProperty(value = "所属上级组织")
    private Long pid;

    /**
     * 所属上级组织编码
     */
    @ApiModelProperty(value = "所属上级组织编码")
    private String pcode;

    /**
     * 所属上级组织名称
     */
    @ApiModelProperty(value = "所属上级组织名称")
    private String pname;

    /**
     * 店面等级
     */
    @ApiModelProperty(value = "店面等级")
    private String storeLevel;

    /**
     * 营业时间段
     */
    @ApiModelProperty(value = "营业时间段")
    private LocalDateTime openTimeSpanStart;


    @ApiModelProperty(value = "营业时间段")
    private LocalDateTime openTimeSpanEnd;

    @ApiModelProperty(value = "营业时间段")
    private String openTimeSpan;

    /**
     * 门店间数
     */
    @ApiModelProperty(value = "门店间数")
    private int storeRoom;

    /**
     * 锅位数
     */
    @ApiModelProperty(value = "锅位数")
    private int hotpotSoupBaseCount;

    /**
     * 餐道长度
     */
    @ApiModelProperty(value = "餐道长度")
    private BigDecimal diningRoadLength;

    /**
     * 店数
     */
    @ApiModelProperty(value = "店数")
    private int storeNum;

    /**
     * 店铺面积
     */
    @ApiModelProperty(value = "店铺面积")
    private BigDecimal storeArea;

    /**
     * 员工数量
     */
    @ApiModelProperty(value = "员工数量")
    private Long storeEmpNum;

    /**
     * 门店标签
     */
    @ApiModelProperty(value = "门店负责人")
    private String storeManager;

    /**
     * 门店标签
     */
    @ApiModelProperty(value = "联系电话")
    private String storeContPhone;

    /**
     * 店铺介绍
     */
    @ApiModelProperty(value = "店铺介绍")
    private String storeIntrodu;

    /**
     * 门店标签
     */
    @ApiModelProperty(value = "门店标签")
    private List<String> storeTags;

    /**
     * 门店状态
     */
    @ApiModelProperty(value = "门店状态")
    private String storeStatus;

    /**
     * 地址号
     */
    @ApiModelProperty(value = "地址号")
    private Long addrNo;

    /**
     * 区域
     */
    @ApiModelProperty(value = "区域")
    private String region;

    /**
     * 营业时间段2
     */
    @ApiModelProperty(value = "营业时间段2")
    private String openTimeSpan2;

    /**
     * 路径
     */
    @ApiModelProperty(value = "路径")
    private String storePath;


    /**
     *申请人
     */
    @ApiModelProperty(value = "申请人")
    private String applyUser;

    /**
     *申请人
     */
    @ApiModelProperty(value = "申请人")
    private Long applyUserId;

    /**
     *申请时间
     */
    @ApiModelProperty(value = "申请时间")
    private LocalDateTime applyTime;

    /**
     * 公司名称
     */
    @ApiModelProperty(value = "公司名称")
    private String ouName;

    /**
     * 所属组织ID
     */
    @ApiModelProperty(value = "所属组织ID")
    private Long buId;

    /**
     * 门店名称2
     */
    @ApiModelProperty(value = "门店名称2")
    private String storeName2;

    /**
     * 门店简称
     */
    @ApiModelProperty(value = "门店简称")
    private String storeAbbr;

    /**
     * 门店状态2
     */
    @ApiModelProperty(value = "门店状态2")
    private String storeStatus2;

    /**
     * 门店状态3
     */
    @ApiModelProperty(value = "门店状态3")
    private String storeStatus3;

    /**
     * 所属公司ID
     */
    @ApiModelProperty(value = "所属公司ID")
    private Long ouId;

    /**
     * 所属公司编码
     */
    @ApiModelProperty(value = "所属公司编码")
    private String ouCode;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;


    // ***************************************************************************
    // ********************************* 门店图片 *********************************
    @ApiModelProperty(value = "门店图片")
    private List<OrgStoreAttachmentSaveRpcParam> storeImages;

    /**
     * 地址簿参数
     */
    @ApiModelProperty(value = "地址簿参数")
    private List<OrgAddrAddressSaveRpcParam> orgAddrSaveParam;


    @ApiModelProperty(value = "区域负责人")
    private String regionRespPerson;


    @ApiModelProperty(value = "渠道类型（线上，线下）")
    private String channelType;


    @ApiModelProperty(value = "渠道编码")
    private String channelCode;


    @ApiModelProperty(value = "渠道名称")
    private String channelName;


    @ApiModelProperty(value = "客户id")
    private String custId;



    @ApiModelProperty(value = "商户号")
    private String merchantIdNum;


    @ApiModelProperty(value = "成本中心编码")
    private String costCode;


    @ApiModelProperty(value = "品牌id")
    private String brandId;


    @ApiModelProperty(value = "品牌编码")
    private String brandCode;


    @ApiModelProperty(value = "  品牌名称")
    private String brandName;


    @ApiModelProperty(value = "品牌中文名")
    private String brandEnName;

    /**
     * 所属组织名称
     */
    @ApiModelProperty(value = "所属组织名称")
    private String buName;

    /**
     * 所属组织编码
     */
    @ApiModelProperty(value = "所属组织编码")
    private String buCode;

    @ApiModelProperty(value = "ERP外部编码")
    private String outerCode;

    @ApiModelProperty(value = "营业生效时间")
    private LocalDateTime openTime;

    @ApiModelProperty(value = "门店冻结时间")
    private LocalDateTime closeTime;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;


    @ApiModelProperty(value = "门店证件")
    @Valid
    private List<OrgStoreLicenseSaveRpcParam> storeLicenses;

    @ApiModelProperty("运费是否计费")
    private Boolean freightFlag;

    @ApiModelProperty("运费比例")
    private BigDecimal freightRatio;

    @ApiModelProperty("供应商运费是否计费")
    private Boolean freightFlag2;

    @ApiModelProperty("供应商运费比例")
    private BigDecimal freightRatio2;

    @ApiModelProperty("门店内部名称")
    private String internalStoreName;

    @ApiModelProperty("使用面积")
    private BigDecimal usedArea;


    @ApiModelProperty("所属阶段")
    private String stage;

    @ApiModelProperty("CRM加盟商编码")
    private String joinCode;

    @ApiModelProperty("CRM加盟商名称")
    private String joinName;


    @ApiModelProperty("加盟商等级")
    private String joinLevel;

    @ApiModelProperty("加盟商类型")
    private Integer joinType;
    //门店联系人
    @ApiModelProperty("联系人")
    private List<OrgContactSaveRpcParam>  orgContactSaveParams;
    //银行信息
    private List<OrgBankSaveRpcParam>  orgBankSaveParams;
    //客户关联还是新增
    @ApiModelProperty("客户关联还是新增,1:关联，0：新增")
    private Integer custRelateFlag;
    //公司关联还是新增
    @ApiModelProperty("公司关联还是新增,1:关联，0：新增")
    private Integer comRelateFlag;

    @ApiModelProperty("建筑类型")
    private String buildingType;

    @ApiModelProperty("创建状态")
    private String createStatus;

    @ApiModelProperty("是否日结")
    private Boolean dailyFlag;

    @ApiModelProperty("是否允许预日结")
    private Boolean preDailyFlag;

    @ApiModelProperty("是否自动日结")
    private Boolean autoDailyFlag;

    @ApiModelProperty("是否补单")
    private Boolean supplementFlag;

    @ApiModelProperty("仓库是否收取项目费用")
    private Boolean whChargeFlag;

    @ApiModelProperty("直送是否收取项目费用")
    private Boolean deliveryChargeFlag;

    @ApiModelProperty("是否控制订货时间")
    private Boolean orderTimeFlag;

    @ApiModelProperty(value = "GMV等级")
    private String gmvLevel;
    private String gmvLevelName;

    @ApiModelProperty(value = "储值公司ID")
    private Long storedOuId;

    @ApiModelProperty(value = "储值公司编号")
    private String storedOuCode;

    @ApiModelProperty(value = "储值公司名称")
    private String storedOuName;

    @ApiModelProperty("费用类型")
    private String costType;

    @ApiModelProperty("费用金额")
    private BigDecimal costAmount;

    @ApiModelProperty("设备清单 多个使用英文逗号分割")
    private String device;


    @ApiModelProperty(value = "发票类型")
    private String invType;

    @ApiModelProperty(value = "开票抬头")
    private String invTitle;

    @ApiModelProperty(value = "开票地址")
    private String invAddress;

    @ApiModelProperty(value = "开票电话")
    private String invTel;

    @ApiModelProperty(value = "开票联系人")
    private String invPicName;

    @ApiModelProperty(value = "开票联系人电话")
    private String invPicPhone;

    @ApiModelProperty(value = "开票银行名称")
    private String invBankName;

    @ApiModelProperty(value = "开票银行支行")
    private String invBankBranch;

    @ApiModelProperty(value = "开票银行账号")
    private String invBankAcc;

    @ApiModelProperty(value = "税号")
    private String taxerNo;

    @ApiModelProperty(value = "开票邮箱")
    private String invEmail;

    @ApiModelProperty("在线支付配置")
    private List<OrgStoreOnlinePayRpcParamVO> orgStoreOnlinePaySaveVOS;

    @ApiModelProperty("发票信息")
    private List<OrgStoreInvoiceInfoParam> orgStoreInvoiceInfoParams;

    private List<OrgStoreCostRpcSaveParam> orgStoreCostSaveParams;



    @ApiModelProperty("是否补充运费")
    private Boolean fillFreightFlag;

    @ApiModelProperty("免运费数量")
    private Integer freeFreightNum;

    @ApiModelProperty("补运费单价")
    private BigDecimal fillFreightPrice;

    @ApiModelProperty("门店价格")
    private BigDecimal storePrice;

    @ApiModelProperty("预计发货周期")
    private Integer expectedDeliveryCycle;

}
