package com.elitesland.support.provider.path.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/9/24 16:32
 * @Description:
 */
@Data
@ApiModel("创建结算路径参数")
public class SupportTransactionPathRpcSaveParam implements Serializable {

    @ApiModelProperty(value = "主表主键Id")
    private Long id;

    @ApiModelProperty(value = "主表主键集合")
    private List<Long> ids;

    @ApiModelProperty(value = "'路径编码")
    private String pathCode;

    @ApiModelProperty(value = "路径名称")
    private String pathName;

    @ApiModelProperty(value = "从公司id")
    private Long companyIdStart;

    @ApiModelProperty(value = "至公司id")
    private Long companyIdEnd;

    @ApiModelProperty(value = "从公司编码")
    private String companyCodeStart;

    @ApiModelProperty(value = "至公司编码")
    private String companyCodeEnd;

    @ApiModelProperty(value = "从公司名称")
    private String companyNameStart;

    @ApiModelProperty(value = "至公司名称")
    private String companyNameEnd;

    @ApiModelProperty(value = "有效期从")
    private LocalDateTime validFrom;

    @ApiModelProperty(value = "有效期至")
    private LocalDateTime validTo;

    @ApiModelProperty(value = "状态")
    private String pathStatus;

    private List<SupportTransactionPathDRpcSaveParam> detailList;
}
