package com.elitesland.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 功能说明:允发期商品组
 * </p>
 *
 * @Author Darren
 * @Date 2023/08/04
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "allowShipItemGroupRpcDTO", description = "允发期商品组主表出参")
public class AllowShipItemGroupRpcDTO implements Serializable {
    private static final long serialVersionUID = -3685925507998507357L;

    /**
     * 主表ID
     */
    @ApiModelProperty("主表ID")
    private Long id;

    /**
     * 编码
     */
    @ApiModelProperty(value = "编码")
    private String code;

    /**
     * 名称
     */
    @ApiModelProperty(value = "名称")
    private String name;

    /**
     * 状态
     */
    @ApiModelProperty(value = "状态 [UDC]yst-supp:COMMON_STATUS")
    @SysCode(sys = "yst-supp", mod = "COMMON_STATUS")
    private String status;
    @ApiModelProperty("状态名称")
    private String statusName;

    /**
     * 类型
     */
    @ApiModelProperty(value = "类型 [UDC]yst-supp:ALLOW_SHIP_ITEM_TYPE")
    @SysCode(sys = "yst-supp", mod = "ALLOW_SHIP_ITEM_TYPE")
    private String type;
    @ApiModelProperty("状态名称")
    private String typeName;

    /**
     * 描述
     */
    @ApiModelProperty(value = "描述")
    private String allowDescribe;

}
