package com.elitesland.support.provider.item.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.item.dto.ItmItemCateRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemQueryCateDTO;
import com.elitesland.support.provider.item.param.ItmItemCateSyncParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author Chris
 * @date 2021-04-27
 */
@FeignClient(name = Application.NAME, path = Application.PATH + ItmItemCateRpcService.PATH)
@Validated
public interface ItmItemCateRpcService {
    String PATH = "/itmItemCateRpc";

    @PostMapping("/findSyncItemCate")
    List<ItmItemCateRpcDTO> findSyncItemCate();


    @PostMapping("/findByCode")
    List<ItmItemQueryCateDTO> findByCode(@RequestBody List<String> cateCodes);

    @PostMapping("/updateSyncStatus")
    ApiResult<Void> updateSyncStatus(@RequestBody List<ItmItemCateSyncParam> paramList);

}
