package com.elitesland.support.provider.org.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@ApiModel("加盟商列表返回参数")
public class OrgFranchiseeSyncRpcDTO implements Serializable {

    private static final long serialVersionUID = -9077656869923559817L;

    @ApiModelProperty(value = "加盟商ID")
    private Long id;

    @ApiModelProperty(value = "加盟商代码")
    private String franchiseeCode;

    @ApiModelProperty(value = "加盟商名称")
    private String franchiseeName;

    @ApiModelProperty(value = "加盟商证件号")
    private String franchiseeDocNo;

    @ApiModelProperty(value = "加盟商联系电话")
    private String franchiseePhone;

    @ApiModelProperty(value = "加盟商状态")
    private String franchiseeStatus;

    @ApiModelProperty(value = "加盟时间")
    private LocalDateTime joinTime;

    @ApiModelProperty(value = "实体类型")
    private String entityType;

    @ApiModelProperty(value = "姓名")
    private String basicInfoName;

    @ApiModelProperty(value = "性别")
    private String basicInfoGender;

    @ApiModelProperty(value = "出生日期")
    private LocalDateTime basicInfoBirthDate;

    @ApiModelProperty(value = "籍贯")
    private String basicInfoOrigin;

    @ApiModelProperty(value = "身份证号码")
    private String basicInfoIdNumber;

    @ApiModelProperty(value = "电子邮箱")
    private String basicInfoEmail;

    @ApiModelProperty(value = "身份证人像面照片URL")
    private String idCardPhotosPortraitSide;

    @ApiModelProperty(value = "身份证国徽面照片URL")
    private String idCardPhotosNationalEmblemSide;

    @ApiModelProperty(value = "签署人姓名")
    private String individualInfoSignatoryName;

    @ApiModelProperty(value = "签署人证件类型")
    private String individualInfoSignatoryDocType;

    @ApiModelProperty(value = "签署人证件号")
    private String individualInfoSignatoryDocNumber;

    @ApiModelProperty(value = "签署人电话")
    private String individualInfoSignatoryPhone;

    @ApiModelProperty(value = "公司名称")
    private String enterpriseInfoCompanyName;

    @ApiModelProperty(value = "统一社会信用代码")
    private String enterpriseInfoCreditCode;

    @ApiModelProperty(value = "法定代表人姓名")
    private String enterpriseInfoLegalPersonName;

    @ApiModelProperty(value = "法定代表人证件类型")
    private String enterpriseInfoLegalPersonDocType;

    @ApiModelProperty(value = "法定代表人身份类型")
    private String enterpriseInfoLegalPersonIdentity;

    @ApiModelProperty(value = "法定代表人证件号")
    private String enterpriseInfoLegalPersonDocNumber;

    @ApiModelProperty(value = "法定代表人手机号")
    private String enterpriseInfoLegalPersonMobile;

    @ApiModelProperty(value = "注册资本")
    private Integer enterpriseInfoRegisteredCapital;

    @ApiModelProperty(value = "成立日期")
    private LocalDateTime enterpriseInfoEstablishmentDate;

    @ApiModelProperty(value = "营业执照照片URL")
    private String enterpriseInfoBusinessLicensePhoto;

    @ApiModelProperty(value = "总积分")
    private Integer performanceMetricsTotalPoints;

    @ApiModelProperty(value = "等级")
    private String performanceMetricsLevel;

    @ApiModelProperty(value = "门店数量")
    private Integer performanceMetricsStoreCount;

    @ApiModelProperty(value = "终止数量")
    private Integer performanceMetricsTerminatedCount;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "数据源")
    private String dataSource;

    @ApiModelProperty(value = "同步状态")
    private String syncStatus;

    @ApiModelProperty(value = "同步错误信息")
    private String syncError;

    @ApiModelProperty(value = "外部系统KEY")
    private String outSysKey;
}
