package com.elitesland.support.provider.org.dto;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 公司工厂表
 *
 * @author chaofeng.xia
 * @date 2024/5/31 16:21
 */
@Data
public class OrgOuFactoryDetailRpcDTO extends CustomFieldBaseModelVo implements Serializable {

    private static final long serialVersionUID = 2849016652981727947L;

    /**
     * 组织id
     */
    @ApiModelProperty("组织id")
    private Long buId;

    /**
     * 组织编号
     */
    @ApiModelProperty("组织编号")
    private String buCode;

    /**
     * 组织名称
     */
    @ApiModelProperty("组织名称")
    private String buName;

    /**
     * 公司ID
     */
    @ApiModelProperty(value = "公司ID")
    private Long ouId;

    /**
     * 公司编码
     */
    @ApiModelProperty(value = "公司编码")
    private String ouCode;

    /**
     * 公司名称
     */
    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty(value = "贸易公司id")
    private Long tradeOuId;

    @ApiModelProperty(value = "贸易公司编码")
    private String tradeOuCode;

    @ApiModelProperty(value = "贸易公司名称")
    private String tradeOuName;

    /**
     * 公司简称
     */
    @ApiModelProperty("公司简称")
    private String ouAbbr;

    /**
     * 字母缩写
     */
    @ApiModelProperty("字母缩写")
    private String abbrAlpha;

    /**
     * 公司类型
     */
    @ApiModelProperty("公司类型")
    private String ouType;

    /**
     * 公司状态 [UDC]COM:STATUS_ACTIVEORNO
     */
    @ApiModelProperty("公司状态 [UDC]COM:STATUS_ACTIVEORNO")
    private String ouStatus;

    /**
     * 法人公司ID
     */
    @ApiModelProperty("法人公司ID")
    private Long legalOuId;

    /**
     * 本位币
     */
    @ApiModelProperty("本位币")
    private String ouCurr;

    /**
     * 地址号
     */
    @ApiModelProperty("地址号")
    private Long addrNo;

    /**
     * 核算编码
     */
    @ApiModelProperty("核算编码")
    private String externalCode;

    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String region;

    /**
     * 开户银行
     */
    @ApiModelProperty(value = "开户银行")
    private String invBankName;

    /**
     * 银行账户
     */
    @ApiModelProperty(value = "银行账户")
    private String invBankAcc;

    /**
     * 联系电话
     */
    @ApiModelProperty(value = "联系电话")
    private String invPicPhone;

    /**
     * 联系地址
     */
    @ApiModelProperty(value = "联系地址")
    private String invAddress;

    /**
     * 开票联系人
     */
    @ApiModelProperty(value = "开票联系人")
    private String invPicName;

    /**
     * 开票抬头
     */
    @ApiModelProperty(value = "开票抬头")
    private String invTitle;

    @ApiModelProperty("是否管理库存 0：否 1：是")
    private Boolean invMgtFlag;

    @ApiModelProperty("是否启用工厂 0：否 1：是")
    private Boolean factoryEnableFlag;


    /**
     * 工厂编码
     */
    @ApiModelProperty(value = "工厂编码")
    private String factoryCode;

    /**
     * 工厂名称
     */
    @ApiModelProperty(value = "工厂名称")
    private String factoryName;

    /**
     * 是否质检 0：否 1：是
     */
    @ApiModelProperty(value = "是否质检 0：否 1：是")
    private Boolean qualityFlag;

    /**
     * 存储条件 [UDC]SUPP:STORE_CONDITION
     */
    @ApiModelProperty(value = "存储条件 [UDC]SUPP:STORE_CONDITION")
    private String storeCondition;
    private List<String> storeConditions;

    /**
     * 是否系统内置 0：否 1：是
     */
    @ApiModelProperty(value = "是否系统内置 0：否 1：是")
    private Boolean sysFlag;

    /**
     * 是否启用 0：禁用 1：启用
     */
    @ApiModelProperty(value = "是否启用 0：禁用 1：启用")
    private Boolean enable;
}
