package com.elitesland.support.component.service.impl;

import com.elitesland.support.component.annotation.dataturbo.DataTurboTransfer;
import com.elitesland.support.component.service.DataTurboTransferService;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Tom.su
 * @description
 * @date 2022/02/20 14:02
 */
@Component
public class DataTurboProcessFactory implements ApplicationContextAware {

    public static final  Map<String, DataTurboTransferService> DATA_TURBO_SERVICE_MAP = new HashMap<>();

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        applicationContext.getBeansWithAnnotation(DataTurboTransfer.class).entrySet().iterator().forEachRemaining(entrySet ->{
            DATA_TURBO_SERVICE_MAP.put(entrySet.getValue().getClass().getAnnotation(DataTurboTransfer.class).value(),
                    (DataTurboTransferService) entrySet.getValue());
        });
    }
}