package com.elitesland.support.component.service.impl;

import com.elitesland.support.component.service.dto.DataTurboInvokeDTO;
import com.elitesland.support.component.service.param.DataTurboInvokeParam;
import com.elitesland.support.component.threadpool.CloseableHttpClientResourcePool;
import com.elitesland.support.component.service.DataTurboInvokeService;
import com.elitesland.support.component.task.DataTurboInvokeTask;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DataTurboInvokeServiceImpl implements DataTurboInvokeService {

    @Autowired
    private CloseableHttpClientResourcePool httpClientResourcePool;

    @Value("${elitesland.dataTurbo.url}")
    private String dataTurboUrl;

    @Value("${elitesland.dataTurbo.user}")
    private String dataTurboUser;

    @Value("${elitesland.dataTurbo.project}")
    private String dataTurboProject;
    @Override
    public DataTurboInvokeDTO invoke(DataTurboInvokeParam dataTurboInvokeParam) throws Exception {
        dataTurboInvokeParam.setUserName(dataTurboUser);
        dataTurboInvokeParam.setProjectName(dataTurboProject);
        DataTurboInvokeTask dataTurboInvokeTask =
                new DataTurboInvokeTask(httpClientResourcePool, dataTurboInvokeParam, dataTurboUrl);
        return dataTurboInvokeTask.call();
    }
}
