/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.support.component.threadpool;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CloseableHttpClientResourcePool {
    private static final Logger log = LoggerFactory.getLogger(CloseableHttpClientResourcePool.class);
    private final ArrayBlockingQueue<CloseableHttpClient> resourcePool;
    private final int poolSize;
    private final int connectionRequestTimeout;
    private final int connectionTimeout;
    private final int socketTimeout;

    public CloseableHttpClientResourcePool() {
        this.poolSize = 10;
        this.resourcePool = new ArrayBlockingQueue(this.poolSize);
        this.connectionRequestTimeout = 30000;
        this.connectionTimeout = 30000;
        this.socketTimeout = 30000;
    }

    public CloseableHttpClient acquireResource(long timeout) throws InterruptedException {
        return this.resourcePool.poll(timeout, TimeUnit.MILLISECONDS);
    }

    public void releaseResource(CloseableHttpClient resource) {
        if (resource != null) {
            this.resourcePool.offer(resource);
        }
    }

    @PostConstruct
    public void initialize() {
        for (int i = 0; i < this.poolSize; ++i) {
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
            connectionManager.setMaxTotal(this.poolSize);
            connectionManager.setDefaultMaxPerRoute(this.poolSize);
            CloseableHttpClient client = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connectionManager).setConnectionManagerShared(true).setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(this.connectionRequestTimeout).setConnectTimeout(this.connectionTimeout).setSocketTimeout(this.socketTimeout).build()).build();
            this.resourcePool.offer(client);
        }
        log.info("^_^\u521d\u59cb\u5316HTTP\u7ebf\u7a0b\u6c60\u6210\u529f[{}]", (Object)this.resourcePool.size());
    }
}

