package com.elitesland.support.component.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitesland.support.component.service.dto.DataTurboInvokeDTO;
import com.elitesland.support.component.service.param.DataTurboInvokeParam;
import com.elitesland.support.component.threadpool.CloseableHttpClientResourcePool;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

@Slf4j
public class DataTurboInvokeTask implements Callable<DataTurboInvokeDTO> {

    private final CloseableHttpClientResourcePool httpClientResourcePool;
    private final Map<String, String> header = new HashMap<>();
    private final DataTurboInvokeParam dataTurboInvokeParam;
    private final String url;

    public DataTurboInvokeTask(CloseableHttpClientResourcePool httpClientResourcePool, DataTurboInvokeParam dataTurboInvokeParam, String url) {
        this.httpClientResourcePool = httpClientResourcePool;
        this.dataTurboInvokeParam = dataTurboInvokeParam;
        this.url = url;
    }

    @Override
    public DataTurboInvokeDTO call() throws Exception {
        CloseableHttpClient httpClient = httpClientResourcePool.acquireResource(10000);
        String currentUrl = String.format(url
                , dataTurboInvokeParam.getProcessName()
                , dataTurboInvokeParam.getProjectName()
                , dataTurboInvokeParam.getUserName());
        HttpPost httpPost = new HttpPost(currentUrl);
        for (Map.Entry<String, String> entry : header.entrySet()) {
            httpPost.setHeader(entry.getKey(), entry.getValue());
        }
        httpPost.setHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        String jsonString = JSON.toJSONString(dataTurboInvokeParam.getStartParams());
        StringEntity entity = new StringEntity(jsonString, Charset.defaultCharset());
        httpPost.setEntity(entity);
        HttpResponse response = null;
        try {
            log.info("begin request dataTurbo process,request body:{}", dataTurboInvokeParam);
            response = httpClient.execute(httpPost);
            String result = EntityUtils.toString(response.getEntity());
            log.info(" ataTurbo process,response:{}", result);
            JSONObject jsonObject = JSONObject.parseObject(result);
            return JSONObject.toJavaObject(jsonObject, DataTurboInvokeDTO.class);
        } catch (Exception t) {
            log.error("sendHttp exception: ", t);
            DataTurboInvokeDTO dataTurboInvokeDTO = new DataTurboInvokeDTO();
            dataTurboInvokeDTO.setCode(-1);
            dataTurboInvokeDTO.setMsg(t.getMessage());
            dataTurboInvokeDTO.setSuccess(false);
            return dataTurboInvokeDTO;
        } finally {
            if (httpClient != null) {
                httpClientResourcePool.releaseResource(httpClient);
            }
        }
    }
}
