package com.elitesland.yst.provider.item.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;


/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/2/8
 */
@Data
@ApiModel("商品品类新增参数")
public class ItmItemCateSaveOpenRpcParam implements Serializable {

    private static final long serialVersionUID = -3139792217612458847L;

    /**
     * Id
     */
    @ApiModelProperty(value = "Id")
    private Long id;

    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")
    private Long pid = 0L;

    /**
     * 排序序号
     */
    @ApiModelProperty(value = "排序序号")
    private Integer sortNo;

    /**
     * 科目级别
     */
    @ApiModelProperty(value = "科目级别")
    private Integer level;

    /**
     * 品类编码
     */
    @ApiModelProperty(value = "品类编码")
    private String itemCateCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(value = "品类名称")
    private String itemCateName;

    /**
     * 是否基础类目（0：不是，1：是）
     */
    @ApiModelProperty(value = "是否基础类目（0：不是，1：是）")
    private Integer itemCateIsBasic;

    /**
     * 状态
     */
    @ApiModelProperty(value = "状态")
    private String status;

    /**
     * 品类描述
     */
    @ApiModelProperty(value = "品类描述")
    private String itemCateDesc;
}
