package com.elitesland.yst.provider.item.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author : Scott.zhang(zhang hang)
 * @date : 2021/04/21/14:52
 */
@Data
@ApiModel(description = "商品计量单位转换保存参数")
public class ItmItemUomConvSaveOpenRpcParam {

    /**
     * 商品ID
     */
    @ApiModelProperty(value = "商品ID")
    private Long itemId;

    /**
     * 从单位 [UDC]COM:UOM
     */
    @ApiModelProperty(value = "从单位 [UDC]COM:UOM")
    private String fromUom;

    /**
     * 到单位 [UDC]COM:UOM
     */
    @ApiModelProperty(value = "到单位 [UDC]COM:UOM")
    private String toUom;

    /**
     * 转换系数
     */
    @ApiModelProperty(value = "转换系数")
    private BigDecimal ratio;



}
