package com.elitesland.yst.provider.item.param;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * @author Chris
 * @date 2021-05-27
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel("经营目录商品DTO分页条件")
public class ItmItemBusinessOpenRpcPagingParam extends AbstractOrderQueryParam implements Serializable {

    private static final long serialVersionUID = -3822555526250684108L;

    /**
     * 品项编号/名称，支持模糊查询
     */
    @ApiModelProperty("品项编号/名称，支持模糊查询")
    private String itemCodeName;

    /**
     * 品项编号列表
     */
    @ApiModelProperty("品项编号列表")
    private List<String> itemCodes;

    /**
     * 品项名称，支持模糊查询
     */
    @ApiModelProperty("品项名称，支持模糊查询")
    private String itemName;

    /**
     * 规格型号，支持模糊查询
     */
    @ApiModelProperty("规格型号，支持模糊查询")
    private String spec;

    /**
     * 品类编号
     */
    @ApiModelProperty("品类编号")
    private String itemCateCode;

    /**
     * 品牌编号/名称，支持模糊查询
     */
    @ApiModelProperty("品牌编号/名称，支持模糊查询")
    private String brandCodeName;

    /**
     * 商品类型 [UDC]ITM:ITEM_TYPE
     */
    @ApiModelProperty("商品类型 [UDC]ITM:ITEM_TYPE")
    private String itemType;

    /**
     * 物料类型 [UDC]ITM:ITEM_TYPE2
     */
    @ApiModelProperty("物料类型 [UDC]ITM:ITEM_TYPE2")
    private String itemType2;

    /**
     * 供应商编号/名称，支持模糊查询
     */
    @ApiModelProperty("供应商编号/名称，支持模糊查询")
    private String suppCodeName;

    /**
     * 商品SKU状态 [UDC]ITM:ITEM_STATUS
     */
    @ApiModelProperty("商品SKU状态 [UDC]ITM:ITEM_STATUS")
    private String itemStatus;

    /**
     * 公司编码列表
     */
    @ApiModelProperty("公司编码列表")
    private List<String> buCodes;

}
