package com.elitesland.yst.provider.item.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author Chris
 * @date 2021-04-12
 */
@Data
public class ItmItemSpuSaveOpenRpcParam implements Serializable {
    private static final long serialVersionUID = 6262038323324543467L;
    // ***************************************************************************
    // ********************************* 基本信息 *********************************

    /**
     * 记录唯一ID
     */
    @ApiModelProperty(value = "记录唯一ID")
    private Long spuId;

    /**
     * SPU编号
     */
    @ApiModelProperty(value = "SPU编号")
    private String spuCode;

    /**
     * SPU编号2
     */
    @ApiModelProperty(value = "SPU编号2")
    private String spuCode2;

    /**
     * SPU名称
     */
    @ApiModelProperty(value = "SPU名称")
    private String spuName;

    /**
     * SPU名称2
     */
    @ApiModelProperty(value = "SPU名称2")
    private String spuName2;

    /**
     * SPU简称
     */
    @ApiModelProperty(value = "SPU简称")
    private String spuAbbr;

    /**
     * 商品类型 [UDC]ITM:ITEM_TYPE
     */
    @ApiModelProperty(value = "商品类型 [UDC]ITM:ITEM_TYPE")
    private String itemType;

    /**
     * 物料类型 [UDC]ITM:ITEM_TYPE2
     */
    @ApiModelProperty(value = "物料类型 [UDC]ITM:ITEM_TYPE2")
    private String itemType2;

    /**
     * 商品类型3
     */
    @ApiModelProperty(value = "商品类型3")
    private String itemType3;


    /**
     * 商品类型4
     */
    @ApiModelProperty(value = "商品类型4")
    private String itemType4;

    /**
     * 商品类型4
     */
    @ApiModelProperty(value = "商品类型4")
    private String itemType5;

    /**
     * 品类编号
     */
    @ApiModelProperty(value = "品类编号")
    private String itemCateCode;

    /**
     * 商品识别号(组织编号)
     */
    @ApiModelProperty(value = "商品识别号(组织编号)")
    private String itemSource;

    /**
     * 品牌编号
     */
    @ApiModelProperty(value = "品牌编号")
    private String brand;

    /**
     * 供应商ID
     */
    @ApiModelProperty(value = "供应商ID")
    private Long suppId;

    /**
     * 供应商编号
     */
    @ApiModelProperty(value = "供应商编号")
    private String suppCode;

    /**
     * 供应商简称
     */
    @ApiModelProperty(value = "供应商简称")
    private String suppAbbr;

    /**
     * 供应商名称
     */
    @ApiModelProperty(value = "供应商名称")
    private String suppName;

    /**
     * 规格型号
     */
    @ApiModelProperty(value = "规格型号")
    private String spec;

    // ***************************************************************************
    // ********************************* 商品图片 *********************************

    private List<ItmItemAttachmentSaveOpenRpcParam> spuImages;

    // ***************************************************************************
    // ********************************* 商品视频 *********************************

    private List<ItmItemAttachmentSaveOpenRpcParam> spuVideos;


    // **************************************************************************************
    // ********************************* 商品规格 SKU 信息列表 *********************************

    private List<ItmItemSkuSaveOpenRpcParam> itemSkuSaveParams;


    // ***************************************************************************
    // ********************************* 商品参数 *********************************
    // ********************* 仓储物流参数 *********************



    /**
     * 是否启用序列号
     */
    @ApiModelProperty(value = "是否启用序列号")
    private Boolean snFlag;

    /**
     * 是否启用批次号
     */
    @ApiModelProperty(value = "是否启用批次号")
    private Boolean lotFlag;

    /**
     * 效期管理标识
     */
    @ApiModelProperty(value = "效期管理标识")
    private Boolean guaranteeFlag;

    /**
     * 配货类型 [UDC]ITM:ALLOC_TYPE
     */
    @ApiModelProperty(value = "配货类型 [UDC]ITM:ALLOC_TYPE")
    private String allocType;

    /**
     * 保质期时长
     */
    @ApiModelProperty(value = "保质期时长")
    private Integer guaranteePeriod;

    /**
     * 保质期单位 [UDC]COM:TIME_UNIT
     */
    @ApiModelProperty(value = "保质期单位 [UDC]COM:TIME_UNIT")
    private String guaranteePeriodUnit;

    /**
     * 运输条件
     */
    @ApiModelProperty(value = "运输条件")
    private String transCondition;

    /**
     * 存储条件 [UDC]yst-supp:STORE_CONDITION
     */
    @ApiModelProperty(value = "存储条件")
    private String storeCondition;


    // ********************* 财务参数 *********************

    /**
     * 财务分类 [UDC]ITM:FIN_TYPE
     */
    @ApiModelProperty(value = "财务分类 [UDC]ITM:FIN_TYPE")
    private String finType;

    /**
     * 成本计价/结算方法 [UDC]ITM:COST_TYPE
     */
    @ApiModelProperty(value = "成本计价/结算方法 [UDC]ITM:COST_TYPE")
    private String costType;

    /**
     * 税收分类码
     */
    @ApiModelProperty(value = "税收分类码")
    private String taxType;

    /**
     * 税率编号(进项)
     */
    @ApiModelProperty(value = "税率编号(进项)")
    private String taxRateNo;

    /**
     * 税率编号2(销项)
     */
    @ApiModelProperty(value = "税率编号2(销项)")
    private String taxRateNo2;

    /**
     * 关税税率，小于1的小数，保留8位，四舍五入
     */
    @ApiModelProperty(value = "关税税率，小于1的小数，保留8位，四舍五入")
    private BigDecimal taxRateTariff;


    // ********************* 服务参数 *********************

    /**
     * 是否需要安装
     */
    @ApiModelProperty(value = "是否需要安装")
    private Boolean installFlag;

    /**
     * 是否可退换货
     */
    @ApiModelProperty(value = "是否可退换货")
    private Boolean returnExchangeFlag;

    /**
     * 退换货政策 [UDC]ITM:RETURN_EXCHANGE_POLICY
     */
    @ApiModelProperty(value = "退换货政策 [UDC]ITM:RETURN_EXCHANGE_POLICY")
    private String returnExchangePolicy;

    /**
     * 是否保修
     */
    @ApiModelProperty(value = "是否保修")
    private Boolean warrantyFlag;

    /**
     * 保修期时长
     */
    @ApiModelProperty(value = "保修期时长")
    private Integer warrantyPeriod;




    /**
     * 保修期单位 [UDC]COM:TIME_UNIT
     */
    @ApiModelProperty(value = "保修期单位 [UDC]COM:TIME_UNIT")
    private String warrantyPeriodUnit;


    // ***************************************************************************
    // ********************************* 商品属性 *********************************

    /**
     * 商品属性列表
     */
    @ApiModelProperty(value = "商品属性列表")
    private List<ItmItemPropSaveOpenRpcParam> itemPropSaveParams;


    // ***************************************************************************
    // ********************************* 商品证照 *********************************

    /**
     * 商品证照信息
     */
    @ApiModelProperty(value = "商品证照信息")
    private List<ItmItemQualifySaveOpenRpcParam> itemQualifySaveParams;


    // ********************************************************************************
    // ********************************* 商品自定义属性 *********************************

    /**
     * 商品自定义属性
     */
    @ApiModelProperty(value = "商品自定义属性")
    private List<ItmItemCustPropSaveOpenRpcParam> itemCustPropSaveParams;

    /**
     * es1
     */
    @ApiModelProperty("es1")
    private String es1;

    /**
     * es2
     */
    @ApiModelProperty("es2")
    private String es2;

    /**
     * es3
     */
    @ApiModelProperty("es3")
    private String es3;

    /**
     * es4
     */
    @ApiModelProperty("es4")
    private String es4;


    /**
     * es5
     */
    @ApiModelProperty("es5")
    private String es5;

    /**
     * es6
     */
    @ApiModelProperty("es6")
    private String es6;

    /**
     * es7
     */
    @ApiModelProperty("es7")
    private String es7;


    /**
     * es8
     */
    @ApiModelProperty("es8")
    private String es8;


    /**
     * es9
     */
    @ApiModelProperty("es9")
    private String es9;


    /**
     * es10
     */
    @ApiModelProperty("es10")
    private String es10;

    /**
     * cat2
     */
    @ApiModelProperty("cat2")
    private String cat2;



    /**
     * 原产国
     */
    @ApiModelProperty(value = "原产国")
    private String menuCountry;


    /**
     * 厂家ID
     */
    @ApiModelProperty(value = "厂家ID")
    private Long manuerId;


    /**
     * 厂家编码
     */
    @ApiModelProperty(value = "厂家编码")
    private String manuerCode;

    /**
     * 厂家名称
     */
    @ApiModelProperty(value = "厂家名称")
    private String manuerName;


    /**
     * 厂家物料编码
     */
    @ApiModelProperty(value = "厂家物料编码")
    private String manuerItemCode;

    /**
     * 商品状态
     */
    @ApiModelProperty("商品状态")
    private String itemStatus;

}
