package com.tll.task.rpc.vo.backlogCenter;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 主任务信息
 *
 * @author Kaiser（qishendeng）
 * @date 2024/10/29
 */
@Data
@ApiModel(description = "主任务信息")
public class MainTaskListRpcVO implements Serializable{

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("任务Id")
    private String taskId;

    @ApiModelProperty("任务名称")
    private String taskName;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("任务备注说明")
    private String taskRemark;

    @ApiModelProperty("任务类型 1:门店任务 2:员工任务")
    private String taskType;

    @ApiModelProperty("任务形式 1:任务型 2:通知型 3:收集型")
    private String taskForm;
    
    @ApiModelProperty("任务状态 1:待生效 2:生效中 3:已回收 4:已归档 5:已过期 ")
    private String taskStatus;

    @ApiModelProperty("任务计划开始时间")
    private LocalDateTime taskPlanStartTime;

    @ApiModelProperty("任务计划结束时间")
    private LocalDateTime taskPlanEndTime;

    @ApiModelProperty("任务开始时间")
    private LocalDateTime taskStartTime;

    @ApiModelProperty("任务结束时间")
    private LocalDateTime taskEndTime;

    @ApiModelProperty("任务提醒 1:无需提醒 2:指定时间提醒 3:固定周期提醒")
    private String taskRemind;

    @ApiModelProperty("任务提醒指定开始时间")
    private LocalDateTime taskRemindStartTime;

    @ApiModelProperty("任务提醒指定结束时间")
    private LocalDateTime taskRemindEndTime;
    
    @ApiModelProperty("任务执行对象 1:门店 2:员工")
    private String taskExecuteObject;

    @ApiModelProperty("是否向上汇总 1:是 2:否")
    private String isUpwardSummary;

    @ApiModelProperty("汇总级数")
    private String upwardSummarySeries;
    
    @ApiModelProperty("甜掌柜是否弹窗 1:是 2:否")
    private String isPopup;

    @ApiModelProperty("弹窗是否可关闭 1:是 2:否")
    private String isPopupClose;

    @ApiModelProperty("弹窗文案")
    private String PopupCopywriter;

    @ApiModelProperty("任务完成情况")
    private String taskCompleteCondition;

    @ApiModelProperty("任务查阅情况")
    private String taskConsultCondition;

    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    
    @ApiModelProperty("是否执行同一个任务 1:是 2:否")
    private String isExecuteSameTask;    
    @ApiModelProperty("是否协同任务 1:是 2:否")
    private String isCotasking;   
    @ApiModelProperty("是否同步门店 1:是 2:否")
    private String isSyncStore;
    @ApiModelProperty("甜管家是否弹窗 1:是 2:否")
    private String seneschalIsPopup;

    @ApiModelProperty("法人是否脱敏 1:是 2:否")
    private String isDesensitization;
    
    @ApiModelProperty("任务内容 1:指定表单 2:指定公告 3:指定链接")
    private String taskNote;

    @ApiModelProperty("任务关联的内容ID")
    private String taskNoteId;

    //详情信息
    private MainTaskListInfoRpcVO mainTaskListInfoVO;
    
}
