package com.tll.task.rpc.vo.backlogCenter;

import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;

@Data
public class StoreTaskItemOptionDetailRpcVO implements Serializable {

    @Comment("记录唯一ID")
    @Column
    private Long id;

    @Comment("所属表单项id")
    @Column(nullable = false)
    private long formItemId;

    @Comment("排序号")
    @Column(nullable = false)
    private int sort;

    @Comment("选项内容")
    @Column(length = 16)
    private String content;


    @Comment("表单项对应选项或值")
    @Column(length = 255)
    private String optionValue;

    @Comment("量表分值")
    @Column(columnDefinition = "int default null")
    private Integer levelNum;

    @Comment("关联表单项id列表（逗号分隔）")
    @ApiModelProperty("关联表单项id列表")
    private String relateFormItemIds;

}
