package com.tll.task.rpc.dto.backlogCenter;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Set;

/**
 * 主任务详情-员工任务列表查询参数
 *
 * @author Jxinx
 * @since 2025-04-15
 */
@Data
@ApiModel(description = "主任务详情-员工任务列表查询参数")
public class EmployeeTaskListQueryRpcDTO extends AbstractExportQueryParam {

    private static final long serialVersionUID = -2998919062828633742L;

    @ApiModelProperty("主任务id")
    private String taskId;

    @ApiModelProperty(value = "子任务状态：0-待提交，1-已完成，2-已回收，3-已过期，4-整改中，5-待审核，6-审核中，7-待整改，8-已失效")
    private Integer taskState;

    @ApiModelProperty("仅看我的：true-是，false-否")
    private boolean onlyCurrentUser;

    @ApiModelProperty("执行人员工id")
    private Set<Long> executeUserId;

    @ApiModelProperty("执行人员工姓名")
    private String executeUserName;

    @ApiModelProperty("执行人部门id")
    private Set<Long> executeUserOrgId;

    @ApiModelProperty("员工任务编号")
    private Set<String> employTaskNumbers;
}
