package com.tll.task.rpc.vo.backlogCenter;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 主任务详情信息
 * @author Kaiser（qishendeng）
 * @date 2024/10/29
 */
@Data
@ApiModel(description = "主任务详情信息")
public class MainTaskListInfoRpcVO implements Serializable{

    @ApiModelProperty("主任务id")
    private String taskId;
    //已完成数量
    @ApiModelProperty("已完成数量")
    private int completedQuantity;
    //全部任务数量
    @ApiModelProperty("全部任务数量")
    private int quantity;
    //百分比
    @ApiModelProperty("百分比")
    private String percent;
    //任务状态
    @ApiModelProperty(value = "任务状态 0：待处理 1：处理中")
    private String status;
    @ApiModelProperty("倒计时状态 0：不存在 1：存在")
    private String isCountdown;
    //倒计时
    @ApiModelProperty("倒计时")
    private int countdown;
    //是否催办
    @ApiModelProperty(value = "是否催办  0：未催办  1:已催办")
    private String isUrge;
    //催办时间
    @ApiModelProperty(value = "催办时间")
    private LocalDateTime urgeTime;
    //是否提醒
    @ApiModelProperty("是否提醒  0：未提醒  1:已提醒")
    private String isWarn;
    //提醒时间
    @ApiModelProperty(value = "提醒时间")
    private LocalDateTime warnTime;
    @ApiModelProperty("任务开始时间")
    private LocalDateTime taskStartTime;
    @ApiModelProperty("任务结束时间")
    private LocalDateTime taskEndTime;
    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;
    @ApiModelProperty(value = "是否是剩余数据")
    private Boolean remaining=false;
    @ApiModelProperty(value = "时间差(与当前时间最短的时间差)")
    private Long timeDifference;
    @ApiModelProperty(value = "今日待办数量")
    private int todayListQuantity;
    @ApiModelProperty(value = "非今日待办数量")
    private int notTodayQuantity;
    
}
