package com.tll.task.rpc.vo.backlogCenter;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author: qishendeng
 * Date: 2024/11/22 14:24
 */
@Data
@ApiModel(value = "查询门店信息加盟店直营店融合")
public class SonyStoreFranchiseRpcVO implements Serializable {
    private static final long serialVersionUID = 1L;

    //法人信息
    @ApiModelProperty(value = "法人")
    private String legalPerson;

    @ApiModelProperty(value = "法人电话")
    private String legalPersonPhone;

    @ApiModelProperty(value = "联系地址")
    private String contactAddress;

    @ApiModelProperty(value = "邮箱")
    private String contactMail;
    
    //基本信息 门店信息
    @ApiModelProperty(value = "门店编号")
    private String storeCode;
    
    @ApiModelProperty(value = "运营状态：0：签约、1：营业中、2：短期闭店、3：空合同、4：到期解约、5：长期闭店、7：待装修、8：强制解约、9：其它解约")
    private Integer operationStatus;

    @ApiModelProperty(value = "门店简称")
    private String storeName;

    @ApiModelProperty(value = "门店名称")
    private String storeDetailName;

    @ApiModelProperty(value = "门店类型：1：加盟店  0：直营店")
    private Integer storeType;

    @ApiModelProperty(value = "门店详细地址")
    private String storeAddress;
    
    @ApiModelProperty(value = "门店营业时间")
    private String storeBusinessHours;

    @ApiModelProperty(value = "门店电话")
    private String storePhone;
    
    @ApiModelProperty(value = "南北战区  ： 南方大区、北方大区")
    private String warArea;

    @ApiModelProperty(value = "大区经理")
    private String regionManager;

    @ApiModelProperty(value = "大区经理id")
    private String regionManagerId;

    @ApiModelProperty(value = "省经理")
    private String provinceManager;

    @ApiModelProperty(value = "省经理id")
    private String provinceManagerId;

    @ApiModelProperty(value = "区域经理")
    private String areaManager;

    @ApiModelProperty(value = "区域经理id")
    private String areaManagerId;

    @ApiModelProperty(value = "督导")
    private String supervisor;

    @ApiModelProperty(value = "直营店长")
    private String storeManager;

    @ApiModelProperty(value = "直营店长id")
    private String storeManagerId;

    @ApiModelProperty(value = "直营店经理")
    private String storeDirector;

    @ApiModelProperty(value = "直营店经理id")
    private String storeDirectorId;

    @ApiModelProperty(value = "直营店主管")
    private String storeSupervisor;

    @ApiModelProperty(value = "直营店主管id")
    private String storeSupervisorId;
    
    @ApiModelProperty(value = "门店创建时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss")
    private LocalDateTime createStoreTime;

}
