package com.tll.task.rpc.dto.employee;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * 员工详情查询请求参数
 *
 * @author Jxinx
 * @date 2024-11-20
 */
@Data
@ApiModel(description = "员工详情查询请求参数")
public class EmployeeDetailQueryRpcDTO implements Serializable {

    private static final long serialVersionUID = -7637959876941369566L;

    /**
     * 员工用户id集合
     */
    @NotEmpty(message = "员工用户id集合不能为空")
    @ApiModelProperty(value = "员工用户id集合")
    private List<Long> userIds;
}
