package com.tll.task.rpc.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

@Data
@ApiModel(description = "任务管理响应实体")
public class TaskInfoRpcVO implements Serializable {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("项目Id")
    private String itemId;

    @ApiModelProperty("任务Id")
    private String taskId;

    @ApiModelProperty("期数")
    private Integer periodNum;

    @ApiModelProperty("任务名称")
    private String taskName;

    @ApiModelProperty("任务备注说明")
    private String taskRemark;

    @ApiModelProperty("任务类型 1:门店任务 2:员工任务")
    private String taskType;

    @ApiModelProperty("任务形式 1:任务型 2:通知型 3:收集型")
    private String taskForm;

    @ApiModelProperty("任务所属部门")
    private String taskDepartment;

    @ApiModelProperty("任务所属部门名称")
    private String taskDepartmentName;

    @ApiModelProperty("任务内容 1:指定表单 2:指定公告")
    private String taskNote;

    @ApiModelProperty("任务关联的内容ID")
    private String taskNoteId;

    @ApiModelProperty("任务关联的内容名称")
    private String taskNoteName;

    @ApiModelProperty("任务状态 1:待生效 2:生效中 3:已回收 4:已归档 5:已过期 ")
    private String taskStatus;

    @ApiModelProperty("任务计划开始时间")
    private LocalDateTime taskPlanStartTime;

    @ApiModelProperty("任务计划结束时间")
    private LocalDateTime taskPlanEndTime;

    @ApiModelProperty("任务开始时间")
    private LocalDateTime taskStartTime;

    @ApiModelProperty("任务结束时间")
    private LocalDateTime taskEndTime;

    @ApiModelProperty("任务提醒指定时间")
    private LocalDate taskRemindAssignTime;

    @ApiModelProperty("任务是否循环执行 1:是 2:否")
    private String isCycle;

    @ApiModelProperty("循环周期 1:每天 2:每周 3:每月 4:每两月 5:每三月 6:自定义时间")
    private String cyclePeriod;

    @ApiModelProperty("循环天数")
    private String cycleDays;

    @ApiModelProperty("任务提醒 1:无需提醒 2:指定时间提醒 3:固定周期提醒")
    private String taskRemind;

    @ApiModelProperty("任务提醒指定开始时间")
    private Date taskRemindStartTime;

    @ApiModelProperty("任务提醒指定结束时间")
    private Date taskRemindEndTime;

    @ApiModelProperty("任务提醒周期 1:每天 2:每周 3:每月 4:每两月 5:每三月 6:自定义时间")
    private String taskRemindCyclePeriod;

    @ApiModelProperty("任务提醒自定义天数")
    private Integer taskRemindDays;

    @ApiModelProperty("任务提醒自定义时间点")
    private Integer taskRemindTime;

    @ApiModelProperty("任务执行对象 1:门店 2:员工")
    private String taskExecuteObject;

    @ApiModelProperty("是否向上汇总 1:是 2:否")
    private String isUpwardSummary;

    @ApiModelProperty("汇总级数")
    private String upwardSummarySeries;

    @ApiModelProperty("任务范围 1:选择门店 2:选择员工 3:指定门店名单 4:指定员工名单")
    private String taskScope;

    @ApiModelProperty("门店列表")
    private List<String> storeCodeList;

    @ApiModelProperty("员工列表")
    private List<Long> employeeIdList;

    @ApiModelProperty("关注人列表")
    private List<Long>  attentionPeopleList;

    @ApiModelProperty("执行角色 1:代理商 2:加盟商 3:店长 4:店员")
    private List<String> executiveRoleList;

    @ApiModelProperty("是否执行同一个任务 1:是 2:否")
    private String isExecuteSameTask;

    @ApiModelProperty("是否协同任务 1:是 2:否")
    private String isCotasking;

    @ApiModelProperty("是否同步门店 1:是 2:否")
    private String isSyncStore;

    @ApiModelProperty("法人是否脱敏 1:是 2:否")
    private String isDesensitization;

    @ApiModelProperty("甜掌柜是否弹窗 1:是 2:否")
    private String isPopup;

    @ApiModelProperty("甜管家是否弹窗 1:是 2:否")
    private String seneschalIsPopup;

    @ApiModelProperty("弹窗是否可关闭 1:是 2:否")
    private String isPopupClose;

    @ApiModelProperty("弹窗文案")
    private String popupCopyWriter;

    @ApiModelProperty(value="完成数量")
    private Integer completeQuantity;

    @ApiModelProperty(value="任务总量")
    private Integer taskTotalQuantity;

    @ApiModelProperty("任务完成情况")
    private String taskCompleteCondition;

    @ApiModelProperty("任务查阅情况")
    private String taskConsultCondition;

    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty("任务是否催办")
    private Boolean hastenWorkFlag;

    @ApiModelProperty("记录创建者")
    private String creator;

    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId;

    @ApiModelProperty("记录最后更新者")
    private String updater;

    @ApiModelProperty("提醒时间")
    private LocalDateTime warnTime;

    @ApiModelProperty("是否提醒  0：未提醒  1:已提醒")
    private Integer isWarn;

    @ApiModelProperty("任务范围信息")
    private List<StoreCritiraRespVo> taskScopeList;

    @ApiModelProperty("任务范围信息")
    private List<StoreCritiraRespVo> attentionPeopleInfoList;

    @ApiModelProperty("任务内容信息")
    private String taskNoteContent;

    @ApiModelProperty("甜掌柜落地页")
    private String merchantLandingPage;

    @ApiModelProperty("任务自定义内容")
    private String taskContent;

}
