package com.tll.task.rpc.vo.backlogCenter;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 员工任务详情
 *
 * @author Jxinx
 * @date 2024-09-07 16:18:39
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(description = "员工任务管理详情")
public class EmployeeTasksDetailsRpcVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 记录唯一ID
     */
    @ApiModelProperty(value = "记录唯一ID")
    private Long id;

    /**
     * 员工任务Id
     */
    @ApiModelProperty(value = "员工任务Id")
    private String employTaskNumber;

    /**
     * 记录创建时间
     */
    @ApiModelProperty(value = "记录创建时间")
    private LocalDateTime createTime;

    /**
     * 任务Id
     */
    @ApiModelProperty(value = "任务Id")
    private String taskId;

    /**
     * 任务名称
     */
    @ApiModelProperty(value = "任务名称")
    private String taskName;

    /**
     * 任务备注
     */
    @ApiModelProperty(value = "任务备注")
    private String taskRemark;

    /**
     * 任务形式
     */
    @ApiModelProperty(value = "任务形式 1:任务型 2:通知型 3:收集型")
    private String taskForm;

    /**
     * 任务内容
     */
    @ApiModelProperty(value = "任务内容 1:指定表单 2:指定公告")
    private String taskNote;

    @ApiModelProperty(value = "表单或公告名称")
    private String titleName;

    /**
     * 催办时间
     */
    @ApiModelProperty(value = "催办时间")
    private LocalDateTime urgeTime;

    /**
     * 描述 (催办说明)
     */
    @ApiModelProperty(value = "描述 (催办说明)")
    private String actionDescribe;

    /**
     * 是否撤销 0：未撤销 1：已撤销
     */
    @ApiModelProperty(value = "是否撤销 0：未撤销 1：已撤销")
    private Integer isBack;

    /**
     * 是否催办  0：未催办  1:已催办
     */
    @ApiModelProperty(value = "是否催办  0：未催办  1:已催办")
    private Integer isUrge;

    /**
     * 查阅状态  0：未查阅  1：已查阅
     */
    @ApiModelProperty(value = "查阅状态  0：未查阅  1：已查阅")
    private Integer isRead;

    /**
     * 任务计划开始时间
     */
    @ApiModelProperty(value = "任务计划开始时间")
    private LocalDateTime taskPlanStartTime;

    /**
     * 任务计划结束时间
     */
    @ApiModelProperty(value = "任务计划结束时间")
    private LocalDateTime taskPlanEndTime;

    /**
     * 任务状态  0：待提交   1：已完成   2：已回收  3：已过期  4：整改中 5：待整改 6：已失效
     */
    @ApiModelProperty(value = "任务状态  0：待提交   1：已完成   2：已回收  3：已过期  4：整改中 5：待整改 6：已失效")
    private Integer taskState;

    /**
     * 任务创建人
     */
    @ApiModelProperty(value = "任务创建人")
    private String createBy;

    /**
     * 计划执行人
     */
    @ApiModelProperty(value = "计划执行人")
    private String planExecutor;

    /**
     * 实际执行人
     */
    @ApiModelProperty(value = "实际执行人")
    private String realExecutor;

    /**
     * 实际执行人角色
     */
    @ApiModelProperty(value = "实际执行人角色")
    private String realExecutorRole;

    /**
     * 任务所属部门id
     */
    @ApiModelProperty(value = "任务所属部门id")
    private Long taskDepartmentId;

    /**
     * 任务所属部门名称
     */
    @ApiModelProperty(value = "任务所属部门名称")
    private String taskDepartment;

    /**
     * 任务关联表单
     */
    private List<EmployeeTaskFormItemDetailRpcVO> formItemList;

    /**
     * 任务关联公告
     */
    private EmployeeAnnouncementsDetailRpcVO announcementsDetailVO;

    /**
     * 任务协同人角色
     */
    @ApiModelProperty("任务协同人角色")
    private List<String> cotaskingRoleList;

    // 任务关联链接（taskNote=3时）
    @ApiModelProperty("指定链接内容")
    private String linkContent;

    // 任务关联页面（taskNote=7时）
    @ApiModelProperty("页面名称")
    private String pageName;
    @ApiModelProperty("页面链接")
    private String pagePath;
}
