package com.tll.task.rpc.dto.backlogCenter;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 任务列表C端入参
 *
 * @author Kaiser（qishendeng）
 * @date 2024/10/29
 */
@Data
@ApiModel(description = "任务列表C端入参")
public class EmployeeTaskListRpcDTO extends AbstractExportQueryParam {

    @ApiModelProperty("登录人id")
    private Long userId;

    @ApiModelProperty("主任务id")
    private String taskId;

    @ApiModelProperty(value = "子任务状态  0：待提交   1：已完成   2：已回收  3：已过期  4：整改中 5：待整改 6：已失效")
    private String taskState;

    @ApiModelProperty(value = "起始时间")
    private LocalDateTime joinTimeStart;

    @ApiModelProperty(value = "截止时间")
    private LocalDateTime joinTimeEnd;

    @ApiModelProperty("任务开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime taskStartTime;

    @ApiModelProperty("任务结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime taskEndTime;

    @ApiModelProperty("员工任务编号list")
    List<String> employTaskNumberList;

    @ApiModelProperty("门店任务idlist")
    List<String> storeTaskIdList;

    @ApiModelProperty("门店编码")
    private String storeCoding;

    @ApiModelProperty("仅看我的")
    private Boolean onlyMe;

    @ApiModelProperty("部门id")
    private String deptId;

    @ApiModelProperty(value="门店名称")
    private String storeName;

    @ApiModelProperty(value = "法人姓名")
    private String legalPersonName;

    @ApiModelProperty(value = "法人手机号")
    private String legalPersonPhone;

    @ApiModelProperty("搜索内容")
    private String keyword;

    @ApiModelProperty(value = "门店编码列表")
    private List<String> storeCodes;
}
