package com.tll.task.rpc.dto.employee;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 员工列表查询参数
 *
 * @author Jxinx
 * @date 2024-11-19
 */
@Data
@ApiModel(description = "员工列表查询参数")
public class EmployeeListQueryRpcDTO extends AbstractExportQueryParam {

    private static final long serialVersionUID = -196500564483330563L;

    /**
     * 姓名
     */
    @ApiModelProperty(value = "姓名")
    private String fullName;

    /**
     * 姓名
     */
    @ApiModelProperty(value = "组织id")
    private Long orgId;

    /**
     * 是否返回所在组织，默认返回
     */
    @ApiModelProperty(hidden = true)
    private Boolean withOrg = true;

}
