package com.tll.task.rpc.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import lombok.Data;

/**
 * 表单项响应实体数据
 *
 * @author Jxinx
 * @date 2024-09-11
 */
@Data
@ApiModel(description = "表单项响应实体数据")
public class FormItemRpcVO implements Serializable {

    private static final long serialVersionUID = 9188302268612702896L;

    /**
     * 表单项id
     */
    @ApiModelProperty(value = "表单项id")
    private Long id;

    /**
     * 排序号
     */
    @ApiModelProperty(value = "排序号")
    private Integer sort;

    /**
     * 表单项类型：1-单选，2-多选，3-下拉框，4-图片，5-视频，6-文本框，7-量表题，8-定位，9-地址，10-日期，11-门店，12-长文本
     */
    @ApiModelProperty(value = "表单项类型：1-单选，2-多选，3-下拉框，4-图片，5-视频，6-文本框，7-量表题，8-定位，9-地址，10-日期，11-门店，12-长文本", required = true)
    private Integer type;

    /**
     * 标题
     */
    @ApiModelProperty(value = "标题", required = true)
    private String title;

    /**
     * 填写提示
     */
    @ApiModelProperty(value = "填写提示")
    private String hint;

    /**
     * 是否必填：0-否，1-是
     */
    @ApiModelProperty(value = "是否必填：0-否，1-是")
    private Integer isRequired;

    /**
     * 是否有填写提示：0-否，1-是
     */
    @ApiModelProperty(value = "是否有填写提示：0-否，1-是")
    private Integer isRemind;

    /**
     * 图片是否添加水印：0-否，1-是
     */
    @ApiModelProperty(value = "图片是否添加水印：0-否，1-是")
    private Integer isImgWatermark;

    /**
     * 图片必需数量
     */
    @ApiModelProperty(value = "图片必需数量")
    private Integer imgNumber;

    /**
     * 图片上传规则：0-不限，1-仅限拍照上传
     */
    @ApiModelProperty(value = "图片上传规则：0-不限，1-仅限拍照上传")
    private Integer imgUploadRule;

    /**
     * 视频必需数量
     */
    @ApiModelProperty(value = "视频必需数量")
    private Integer videoNumber;

    /**
     * 定位是否允许修改：0-否，1-是
     */
    @ApiModelProperty(value = "定位是否允许修改：0-否，1-是")
    private Integer isModifyLocation;

    /**
     * 是否为起止日期：0-否，1-是
     */
    @ApiModelProperty(value = "是否为起止日期：0-否，1-是")
    private Integer isRangeDate;

    /**
     * 地址层级：1-省市区详细地址，2-省市区，3-省市，4-省
     */
    @ApiModelProperty(value = "地址层级：1-省市区详细地址，2-省市区，3-省市，4-省")
    private Integer addressLevel;

    /**
     * 量表等级
     */
    @ApiModelProperty(value = "量表等级")
    private Integer scaleLevel;

    @ApiModelProperty(value = "是否是数字：0-否，1-是")
    private Integer isNumber;

    /**
     * 示例展示方式：1-平铺展示，2-收起展示
     */
    @ApiModelProperty(value = "示例展示方式：1-平铺展示，2-收起展示")
    private Integer describeShowMode;

    /**
     * 示例内容类型：1-自定义，2-关联公告
     */
    @ApiModelProperty(value = "示例内容类型：1-自定义，2-关联公告")
    private Integer describeContentType;

    /**
     * 示例内容
     */
    @ApiModelProperty(value = "示例内容")
    private String describeContent;

    /**
     * 关联此表单项的选项ID列表
     */
    @ApiModelProperty("关联此表单项的选项ID列表")
    private List<Long> relateOptionId;

    /**
     * 表单项内容集合
     */
    @ApiModelProperty(value = "表单项内容集合")
    private List<FormItemOptionRpcVO> formItemOptions;
}
