package com.tll.task.rpc.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import lombok.Data;

import java.io.Serializable;

/**
 * 表单详情响应实体数据
 *
 * @author Jxinx
 * @date 2024-09-11
 */
@Data
@ApiModel(description = "表单详情响应实体数据")
public class FormDetailRpcVO implements Serializable {


    /**
     * 记录唯一ID
     */
    @ApiModelProperty(value = "记录唯一ID")
    private Long id;

    /**
     * 表单所属部门id
     */
    @ApiModelProperty(value = "表单所属部门id")
    private Long departmentId;

    /**
     * 表单所属部门名称
     */
    @ApiModelProperty(value = "表单所属部门名称")
    private String departmentName;

    /**
     * 表单id
     */
    @ApiModelProperty(value = "表单id")
    private String formId;

    /**
     * 表单名称
     */
    @ApiModelProperty(value = "表单名称")
    private String formName;

    /**
     * 表单分类：1-任务表单，2-巡检表单
     */
    @ApiModelProperty(value = "表单分类：1-任务表单，2-巡检表单")
    private List<Integer> formTypes;

    /**
     * 表单状态：0-草稿，2-空闲，3-待启用，4-启用中，5-已使用
     */
    @ApiModelProperty(value = "表单状态：0-草稿，2-空闲，3-待启用，4-启用中，5-已使用")
    private Integer formStatus;

    /**
     * 表单项集合
     */
    @ApiModelProperty(value = "表单项集合")
    private List<FormItemRpcVO> formItems;
}
