package com.tll.task.rpc.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 员工任务操作请求实体类
 *
 * @author Jxinx
 * @date 2024-12-20
 */
@Data
@ApiModel(description = "员工任务操作请求参数")
public class EmployeeTaskRpcDTO implements Serializable {

    private static final long serialVersionUID = 1795142157730700617L;

    /**
     * 员工任务Id
     */
    @NotBlank(message = "员工任务Id不能为空")
    @ApiModelProperty(value = "员工任务Id")
    private String employTaskNumber;

    /**
     * 任务状态
     */
    @NotNull(message = "任务状态不能为空")
    @ApiModelProperty("任务状态：0-待提交，1-已完成，2-已回收，3-已过期，4-整改中，5-待审核，6-审核中，7-待整改，8-已失效")
    private Integer taskState;
}
