package com.tll.task.rpc.dto.backlogCenter;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 待办主任务列表查询参数.
 *
 * @author Kaiser（qishendeng）
 * @date 2024/10/29
 */
@Data
@ApiModel(description = "待办主任务列表查询参数")
public class StoreAffairsListRpcDTO extends AbstractExportQueryParam {

    @ApiModelProperty("登录人id")
    private Long userId;

    @ApiModelProperty(value = "门店任务状态  0：待提交   1：已完成   2：已回收  3：已过期  4：整改中 5：待审核   6：审核中   7：待整改 8：已失效 9：存草稿")
    private Integer status;

    @ApiModelProperty("任务类型 1:门店任务 2:员工任务")
    private String taskType;
    
    @ApiModelProperty(value = "起始时间")
    private LocalDateTime joinTimeStart;
    
    @ApiModelProperty(value = "截止时间")
    private LocalDateTime joinTimeEnd;

    @ApiModelProperty("任务名称")
    private String taskName;

    @ApiModelProperty("门店编码")
    private String storeCoding;
    
}
