package com.tll.task.rpc.dto;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 员工任务列表查询请求实体类
 *
 * @author Jxinx
 * @date 2024-12-20
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(description = "员工任务管理详情")
public class EmployeeTaskPageQueryRpcDTO extends AbstractExportQueryParam implements Serializable {

    private static final long serialVersionUID = 1876990543488881608L;

    @ApiModelProperty(value = "业务类型：1-中台创建，2-业务创建")
    private String businessType;

    @ApiModelProperty(value = "当前用户id")
    private Long currentUserId;

    @ApiModelProperty(value = "当前主任务id")
    private List<String> taskIdList;

    @ApiModelProperty(value = "用户Id or 名字查询", example = "李四")
    private String userInfoQuery;

    @ApiModelProperty(value = "项目信息，支持输入项目ID或名称查询", example = "测试任务")
    private String itemInfo;

    @ApiModelProperty(value = "内容信息，支持输入表单/公告 ID 或名称查询", example = "公告123")
    private String contentInfo;

    @ApiModelProperty(value = "任务信息，支持输入任务 ID 或任务名称查询", example = "任务456")
    private String taskInfo;

    @ApiModelProperty(value = "任务形式 1:任务型 2:通知型  支持多选", example = "[\"1\", \"2\"]")
    private String[] taskForms;

    @ApiModelProperty(value = "默认全部 0:执行人 1:关注人 2:参与人(接收汇报者) 3:创建人", example = "3")
    private Integer taskRole;

    @ApiModelProperty(value = "查阅状态，0:未查阅 1:已查阅", example = "0")
    private Integer readStatus;

    @ApiModelProperty(value = "任务状态，默认全部，支持多选（0-待提交，1-已完成，2-已回收，3-已过期，4-整改中，5-待审核，6-审核中，7-待整改，8-已失效）", example = "[1,2,3]")
    private List<Integer> taskStatuses;

    @ApiModelProperty(value = "任务创建人", example = "张三")
    private String taskCreator;

    @ApiModelProperty(value = "任务执行人", example = "李四")
    private String realExecutor;

    @ApiModelProperty(value = "计划执行人员工id")
    private List<Long> planExecutorIds;

    @ApiModelProperty(value = "创建时间开始，指任务的创建时间（注：这个时间与任务创建的时间不同，为任务设置的开始时间），即任务实际完成分发的时间，默认不填，查询近一年时间。支持自定义时间段", example = "1630454400000")
    private LocalDateTime creationTimeStart;

    @ApiModelProperty(value = "创建时间结束，指任务的创建时间（注：这个时间与任务创建的时间不同，为任务设置的开始时间），即任务实际完成分发的时间，默认不填，查询近一年时间。支持自定义时间段", example = "1633046400000")
    private LocalDateTime creationTimeEnd;

    @ApiModelProperty(value = "结束时间开始，指任务的计划结束时间，默认不填，查询全部。支持自定义时间段", example = "1630454400000")
    private LocalDateTime endTimeStart;

    @ApiModelProperty(value = "结束时间结束，指任务的计划结束时间，默认不填，查询全部。支持自定义时间段", example = "1633046400000")
    private LocalDateTime endTimeEnd;

    @ApiModelProperty(value = "任务所属部门", example = "技术部")
    private String taskDepartment;

    @ApiModelProperty(value = "任务所属部门Id", example = "892547380673515335")
    private Long taskDepartmentId;
}
