package com.tll.task.rpc.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author XieBeiChen
 * @date 2025-10-16 10:27
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
@ApiModel(description = "批量移交结果VO")
public class BatchTaskTransferRpcVO {

    @ApiModelProperty(value = "总数量")
    private Integer totalCount;

    @ApiModelProperty(value = "成功数量")
    private Integer successCount;

    @ApiModelProperty(value = "失败数量")
    private Integer failCount;

    @ApiModelProperty(value = "成功的任务ID列表")
    private List<String> successTaskIds;

    @ApiModelProperty(value = "失败的任务ID列表")
    private List<String> failTaskIds;

    @ApiModelProperty(value = "错误信息列表")
    private List<String> errorMessages;
}