package com.tll.task.rpc.vo.backlogCenter;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * Author: daidemin
 * Date: 2024/9/3 10:02
 */
@Data
@ApiModel(description = "门店任务信息")
public class StoreTaskDetailRpcVO implements Serializable{
    private static final long serialVersionUID = -1L;


    @ApiModelProperty(value = "主任务Id")
    private String taskId;
    @ApiModelProperty(value = "门店任务Id")
    private String storeTaskId;
    @ApiModelProperty(value = "任务名称")
    private String taskName;
    @ApiModelProperty("任务内容 1:指定表单 2:指定公告")
    private String taskNote;
    @ApiModelProperty("任务形式 1:任务型 2:通知型 3:收集型")
    private Integer taskType;
    @ApiModelProperty(value = "任务备注说明")
    private String taskRemark;
    @ApiModelProperty(value = "门店任务状态  0：待提交   1：已完成   2：已回收  3：已过期  4：整改中 5：待审核   6：审核中   7：待整改 8：已失效")
    private Integer taskState;
    @ApiModelProperty(value = "门店任务状态名")
    private String taskStateStr;
    @ApiModelProperty(value = "门店编码")
    private String storeCoding;
    @ApiModelProperty(value = "门店名称")
    private String storeName;
    @ApiModelProperty(value = "法人")
    private String legalPerson;
    @ApiModelProperty(value = "法人手机号")
    private String legalPersonPhone;
    @ApiModelProperty(value = "门店地址")
    private String storeAddress;
    @ApiModelProperty(value = "计划执行人")
    private String planExecutor;
    @ApiModelProperty(value = "实际执行人")
    private String realExecutor;
    @ApiModelProperty(value = "计划执行角色")
    private String PlanExecutorRole;
    @ApiModelProperty(value = "实际执行人角色")
    private String realExecutorRole;
    @ApiModelProperty(value = "查阅状态  0：未查阅  1：已查阅")
    private Integer isRead;
    @ApiModelProperty(value = "南北战区")
    private String region;
    @ApiModelProperty(value = "大区经理")
    private String bigRegionalManager;
    @ApiModelProperty(value = "省经理")
    private String provinceManager;
    @ApiModelProperty(value = "区域经理")
    private String regionalManager;
    @ApiModelProperty(value = "任务创建人")
    private String creator;
    @ApiModelProperty(value = "任务创建时间")
    private LocalDateTime createTime;
    @ApiModelProperty(value = "任务开始时间")
    private LocalDateTime beginTime;
    @ApiModelProperty(value = "任务结束时间")
    private LocalDateTime endTime;
    @ApiModelProperty(value = "实际执行时间")
    private LocalDateTime realEndTime;
    @ApiModelProperty(value = "最近一次任务编辑人")
    private String updater;
    @ApiModelProperty(value = "任务编辑时间")
    private LocalDateTime modifyTime;
    @ApiModelProperty(value = "撤销状态 0：未撤销 1：已撤销")
    private Integer isBack;
    @ApiModelProperty(value = "催办状态 0：未催办 1：已催办")
    private Integer urgeState;

    @ApiModelProperty(value = "任务计划执行人姓名（企业员工，多个逗号拼接）")
    private String planExecutorNames;

    @ApiModelProperty(value = "任务计划执行人姓名（执行人，多个逗号拼接，不包含企业员工）")
    private String planStoreExecutorNames;

    @ApiModelProperty("任务协同人角色")
    private List<String> cotaskingRoleList;

    // 任务关联 表单
    private List<StoreTaskFormItemDetailRpcVO> formItemList;

    /**
     * 表单中有无设置关联（0无/1是）
     */
    @ApiModelProperty("表单中有无设置关联（0无/1是）")
    private Integer hasAnyRelate;

    // 任务关联公告
    private StoreAnnouncementsDetailRpcVO announcementsDetailVO;

    /**
     * 是否逾期：0-未逾期，1-已逾期
     */
    @ApiModelProperty(value = "是否逾期：0-未逾期，1-已逾期")
    private Integer isOverdue;

    /**
     * 是否逾期名称：未逾期/已逾期
     */
    @ApiModelProperty(value = "是否逾期名称：未逾期/已逾期")
    private String isOverdueName;

    // 任务关联链接（taskNote=3时）
    @ApiModelProperty("指定链接内容")
    private String linkContent;

    // 任务关联页面（taskNote=7时）
    @ApiModelProperty("页面名称")
    private String pageName;
    @ApiModelProperty("页面链接")
    private String pagePath;

    // 默认详情页内容（taskNote=8时）
    @ApiModelProperty("默认详情页内容")
    private String defaultPageContent;


}
