package com.elitesland.sale2c.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel("门店营业情况返回")
public class Sale2cSoMpRpcDTO implements Serializable {
    private static final long serialVersionUID = -6128769189915951698L;

    @ApiModelProperty("零售单ID")
    private Long id;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("业务日期")
    private LocalDateTime businessDate;

    @ApiModelProperty("商品销售数量")
    private BigDecimal saleQty;

    @ApiModelProperty("流水金额")
    private BigDecimal flowAmt;

    @ApiModelProperty("实收金额")
    private BigDecimal receiptAmt;

    @ApiModelProperty("优惠金额")
    private BigDecimal discountAmt;

}
