package com.elitesland.sale2c.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.math.BigDecimal;

import java.io.Serializable;
import java.util.List;

@Data
@ApiModel("零售单信息返回")
public class Sale2cSoRpcDTO implements Serializable {
    private static final long serialVersionUID = 5541633801001503679L;

    @ApiModelProperty("零售单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("单据编码")
    private String docNo;

    @ApiModelProperty("外部订单号")
    private String outDocNo;

    @ApiModelProperty("单据类型")
    @SysCode(sys = "yst-sale2c", mod = "SO_TYPE")
    private String docType;
    private String docTypeName;

    @ApiModelProperty("单据状态")
    @SysCode(sys = "yst-sale2c", mod = "SO_STATUS")
    private String docStatus;
    private String docStatusName;

    @ApiModelProperty("门店id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long storeId;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("门店名称")
    private String storeName;

    @ApiModelProperty("公司编码")
    private Long ouId;

    @ApiModelProperty("公司编号")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("零售单行信息")
    private List<Sale2cSoDRpcDTO> itemList;

    @ApiModelProperty("应收金额")
    private BigDecimal receivableAmt;

    @ApiModelProperty("实收金额")
    private BigDecimal receiptAmt;
}
