package com.elitesland.sale2c.dto.syncPos;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@ApiModel("零售单支付明细返回")
public class PSSale2cSoPayRpcDTO extends BaseViewModel implements Serializable {

    @ApiModelProperty("零售单ID")
    @Comment("零售单ID")

    private Long masId;

    @ApiModelProperty("支付方式编码")
    @Comment("支付方式编码")

    private String payCode;

    @ApiModelProperty("支付方式名称")
    @Comment("支付方式名称")

    private String payName;

    @ApiModelProperty("实付金额")
    @Comment("实付金额")

    private BigDecimal receiptAmt;

    @ApiModelProperty("储值卡优惠金额")
    @Comment("储值卡优惠金额")

    private BigDecimal cardDiscountsAmt;

    @ApiModelProperty("优惠券优惠金额")
    @Comment("优惠券优惠金额")

    private BigDecimal couponDiscountsAmt;

    @ApiModelProperty("积分优惠金额")
    @Comment("积分优惠金额")

    private BigDecimal pointDiscountsAmt;

    @ApiModelProperty("第三方优惠金额")
    @Comment("第三方优惠金额")

    private BigDecimal thirdDiscountsAmt;

    @ApiModelProperty("第三方补贴")
    @Comment("第三方补贴")

    private BigDecimal thirdSubsidy;

    @ApiModelProperty("第三方商户")
    @Comment("第三方商户")

    private BigDecimal thirdTenant;

    @ApiModelProperty("商户订单号")
    @Comment("商户订单号")

    private String tenantOrder;

    @ApiModelProperty("储值卡编码")
    @Comment("储值卡编码")

    private String cardCode;

    @ApiModelProperty("优惠券编码")
    @Comment("优惠券编码")

    private String couponCode;

    @ApiModelProperty("第三方优惠券编码")
    @Comment("第三方优惠券编码")

    private String thirdCouponCode;

    @ApiModelProperty("业务日期")
    @Comment("业务日期")

    private LocalDateTime businessDate;

    @ApiModelProperty("记账日期")
    @Comment("记账日期")

    private LocalDateTime glDate;

}
